package zio.aws.pcs.model
import java.lang.Integer
import zio.aws.pcs.model.primitives.{
  ScalingConfigurationRequestMaxInstanceCountInteger,
  ScalingConfigurationRequestMinInstanceCountInteger
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ScalingConfigurationRequest(
    minInstanceCount: ScalingConfigurationRequestMinInstanceCountInteger,
    maxInstanceCount: ScalingConfigurationRequestMaxInstanceCountInteger
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pcs.model.ScalingConfigurationRequest = {
    import ScalingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.ScalingConfigurationRequest
      .builder()
      .minInstanceCount(
        ScalingConfigurationRequestMinInstanceCountInteger.unwrap(
          minInstanceCount
        ): Integer
      )
      .maxInstanceCount(
        ScalingConfigurationRequestMaxInstanceCountInteger.unwrap(
          maxInstanceCount
        ): Integer
      )
      .build()
  }
  def asReadOnly: zio.aws.pcs.model.ScalingConfigurationRequest.ReadOnly =
    zio.aws.pcs.model.ScalingConfigurationRequest.wrap(buildAwsValue())
}
object ScalingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pcs.model.ScalingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.ScalingConfigurationRequest =
      zio.aws.pcs.model
        .ScalingConfigurationRequest(minInstanceCount, maxInstanceCount)
    def minInstanceCount: ScalingConfigurationRequestMinInstanceCountInteger
    def maxInstanceCount: ScalingConfigurationRequestMaxInstanceCountInteger
    def getMinInstanceCount: ZIO[
      Any,
      Nothing,
      ScalingConfigurationRequestMinInstanceCountInteger
    ] = ZIO.succeed(minInstanceCount)
    def getMaxInstanceCount: ZIO[
      Any,
      Nothing,
      ScalingConfigurationRequestMaxInstanceCountInteger
    ] = ZIO.succeed(maxInstanceCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.ScalingConfigurationRequest
  ) extends zio.aws.pcs.model.ScalingConfigurationRequest.ReadOnly {
    override val minInstanceCount
        : ScalingConfigurationRequestMinInstanceCountInteger =
      zio.aws.pcs.model.primitives
        .ScalingConfigurationRequestMinInstanceCountInteger(
          impl.minInstanceCount()
        )
    override val maxInstanceCount
        : ScalingConfigurationRequestMaxInstanceCountInteger =
      zio.aws.pcs.model.primitives
        .ScalingConfigurationRequestMaxInstanceCountInteger(
          impl.maxInstanceCount()
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.ScalingConfigurationRequest
  ): zio.aws.pcs.model.ScalingConfigurationRequest.ReadOnly = new Wrapper(impl)
}
