package zio.aws.pcs.model
import scala.jdk.CollectionConverters.*
sealed trait SchedulerType {
  def unwrap: software.amazon.awssdk.services.pcs.model.SchedulerType
}
object SchedulerType {
  def wrap(
      value: software.amazon.awssdk.services.pcs.model.SchedulerType
  ): zio.aws.pcs.model.SchedulerType = value match {
    case software.amazon.awssdk.services.pcs.model.SchedulerType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pcs.model.SchedulerType.SLURM =>
      val r = SLURM
      r
  }
  case object unknownToSdkVersion extends zio.aws.pcs.model.SchedulerType {
    override def unwrap
        : software.amazon.awssdk.services.pcs.model.SchedulerType =
      software.amazon.awssdk.services.pcs.model.SchedulerType.UNKNOWN_TO_SDK_VERSION
  }
  case object SLURM extends zio.aws.pcs.model.SchedulerType {
    override def unwrap
        : software.amazon.awssdk.services.pcs.model.SchedulerType =
      software.amazon.awssdk.services.pcs.model.SchedulerType.SLURM
  }
}
