package zio.aws.pcs.model
import scala.jdk.CollectionConverters.*
sealed trait Size { def unwrap: software.amazon.awssdk.services.pcs.model.Size }
object Size {
  def wrap(
      value: software.amazon.awssdk.services.pcs.model.Size
  ): zio.aws.pcs.model.Size = value match {
    case software.amazon.awssdk.services.pcs.model.Size.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pcs.model.Size.SMALL =>
      val r = SMALL
      r
    case software.amazon.awssdk.services.pcs.model.Size.MEDIUM =>
      val r = MEDIUM
      r
    case software.amazon.awssdk.services.pcs.model.Size.LARGE =>
      val r = LARGE
      r
  }
  case object unknownToSdkVersion extends zio.aws.pcs.model.Size {
    override def unwrap: software.amazon.awssdk.services.pcs.model.Size =
      software.amazon.awssdk.services.pcs.model.Size.UNKNOWN_TO_SDK_VERSION
  }
  case object SMALL extends zio.aws.pcs.model.Size {
    override def unwrap: software.amazon.awssdk.services.pcs.model.Size =
      software.amazon.awssdk.services.pcs.model.Size.SMALL
  }
  case object MEDIUM extends zio.aws.pcs.model.Size {
    override def unwrap: software.amazon.awssdk.services.pcs.model.Size =
      software.amazon.awssdk.services.pcs.model.Size.MEDIUM
  }
  case object LARGE extends zio.aws.pcs.model.Size {
    override def unwrap: software.amazon.awssdk.services.pcs.model.Size =
      software.amazon.awssdk.services.pcs.model.Size.LARGE
  }
}
