package zio.aws.pcs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SlurmAuthKey(secretArn: String, secretVersion: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pcs.model.SlurmAuthKey = {
    import SlurmAuthKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.SlurmAuthKey
      .builder()
      .secretArn(secretArn: java.lang.String)
      .secretVersion(secretVersion: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.pcs.model.SlurmAuthKey.ReadOnly =
    zio.aws.pcs.model.SlurmAuthKey.wrap(buildAwsValue())
}
object SlurmAuthKey {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.pcs.model.SlurmAuthKey] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.SlurmAuthKey =
      zio.aws.pcs.model.SlurmAuthKey(secretArn, secretVersion)
    def secretArn: String
    def secretVersion: String
    def getSecretArn: ZIO[Any, Nothing, String] = ZIO.succeed(secretArn)
    def getSecretVersion: ZIO[Any, Nothing, String] = ZIO.succeed(secretVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.SlurmAuthKey
  ) extends zio.aws.pcs.model.SlurmAuthKey.ReadOnly {
    override val secretArn: String = impl.secretArn(): String
    override val secretVersion: String = impl.secretVersion(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.SlurmAuthKey
  ): zio.aws.pcs.model.SlurmAuthKey.ReadOnly = new Wrapper(impl)
}
