package zio.aws.pcs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SlurmCustomSetting(
    parameterName: String,
    parameterValue: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pcs.model.SlurmCustomSetting = {
    import SlurmCustomSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.SlurmCustomSetting
      .builder()
      .parameterName(parameterName: java.lang.String)
      .parameterValue(parameterValue: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.pcs.model.SlurmCustomSetting.ReadOnly =
    zio.aws.pcs.model.SlurmCustomSetting.wrap(buildAwsValue())
}
object SlurmCustomSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pcs.model.SlurmCustomSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.SlurmCustomSetting =
      zio.aws.pcs.model.SlurmCustomSetting(parameterName, parameterValue)
    def parameterName: String
    def parameterValue: String
    def getParameterName: ZIO[Any, Nothing, String] = ZIO.succeed(parameterName)
    def getParameterValue: ZIO[Any, Nothing, String] =
      ZIO.succeed(parameterValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.SlurmCustomSetting
  ) extends zio.aws.pcs.model.SlurmCustomSetting.ReadOnly {
    override val parameterName: String = impl.parameterName(): String
    override val parameterValue: String = impl.parameterValue(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.SlurmCustomSetting
  ): zio.aws.pcs.model.SlurmCustomSetting.ReadOnly = new Wrapper(impl)
}
