package zio.aws.pcs.model
import scala.jdk.CollectionConverters.*
sealed trait SpotAllocationStrategy {
  def unwrap: software.amazon.awssdk.services.pcs.model.SpotAllocationStrategy
}
object SpotAllocationStrategy {
  def wrap(
      value: software.amazon.awssdk.services.pcs.model.SpotAllocationStrategy
  ): zio.aws.pcs.model.SpotAllocationStrategy = value match {
    case software.amazon.awssdk.services.pcs.model.SpotAllocationStrategy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pcs.model.SpotAllocationStrategy.LOWEST_PRICE =>
      val r = `lowest-price`
      r
    case software.amazon.awssdk.services.pcs.model.SpotAllocationStrategy.CAPACITY_OPTIMIZED =>
      val r = `capacity-optimized`
      r
    case software.amazon.awssdk.services.pcs.model.SpotAllocationStrategy.PRICE_CAPACITY_OPTIMIZED =>
      val r = `price-capacity-optimized`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.pcs.model.SpotAllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.pcs.model.SpotAllocationStrategy =
      software.amazon.awssdk.services.pcs.model.SpotAllocationStrategy.UNKNOWN_TO_SDK_VERSION
  }
  case object `lowest-price` extends zio.aws.pcs.model.SpotAllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.pcs.model.SpotAllocationStrategy =
      software.amazon.awssdk.services.pcs.model.SpotAllocationStrategy.LOWEST_PRICE
  }
  case object `capacity-optimized`
      extends zio.aws.pcs.model.SpotAllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.pcs.model.SpotAllocationStrategy =
      software.amazon.awssdk.services.pcs.model.SpotAllocationStrategy.CAPACITY_OPTIMIZED
  }
  case object `price-capacity-optimized`
      extends zio.aws.pcs.model.SpotAllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.pcs.model.SpotAllocationStrategy =
      software.amazon.awssdk.services.pcs.model.SpotAllocationStrategy.PRICE_CAPACITY_OPTIMIZED
  }
}
