package zio.aws.pcs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SpotOptions(
    allocationStrategy: Optional[zio.aws.pcs.model.SpotAllocationStrategy] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.pcs.model.SpotOptions = {
    import SpotOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.SpotOptions
      .builder()
      .optionallyWith(allocationStrategy.map(value => value.unwrap))(
        _.allocationStrategy
      )
      .build()
  }
  def asReadOnly: zio.aws.pcs.model.SpotOptions.ReadOnly =
    zio.aws.pcs.model.SpotOptions.wrap(buildAwsValue())
}
object SpotOptions {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.pcs.model.SpotOptions] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.SpotOptions =
      zio.aws.pcs.model.SpotOptions(allocationStrategy.map(value => value))
    def allocationStrategy: Optional[zio.aws.pcs.model.SpotAllocationStrategy]
    def getAllocationStrategy
        : ZIO[Any, AwsError, zio.aws.pcs.model.SpotAllocationStrategy] =
      AwsError.unwrapOptionField("allocationStrategy", allocationStrategy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.SpotOptions
  ) extends zio.aws.pcs.model.SpotOptions.ReadOnly {
    override val allocationStrategy
        : Optional[zio.aws.pcs.model.SpotAllocationStrategy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allocationStrategy())
        .map(value => zio.aws.pcs.model.SpotAllocationStrategy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.SpotOptions
  ): zio.aws.pcs.model.SpotOptions.ReadOnly = new Wrapper(impl)
}
