package zio.aws.pcs.model
import zio.aws.pcs.model.primitives.{
  ComputeNodeGroupIdentifier,
  AmiId,
  InstanceProfileArn,
  SBClientToken,
  ClusterIdentifier
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateComputeNodeGroupRequest(
    clusterIdentifier: ClusterIdentifier,
    computeNodeGroupIdentifier: ComputeNodeGroupIdentifier,
    amiId: Optional[AmiId] = Optional.Absent,
    subnetIds: Optional[Iterable[String]] = Optional.Absent,
    customLaunchTemplate: Optional[zio.aws.pcs.model.CustomLaunchTemplate] =
      Optional.Absent,
    purchaseOption: Optional[zio.aws.pcs.model.PurchaseOption] =
      Optional.Absent,
    spotOptions: Optional[zio.aws.pcs.model.SpotOptions] = Optional.Absent,
    scalingConfiguration: Optional[
      zio.aws.pcs.model.ScalingConfigurationRequest
    ] = Optional.Absent,
    iamInstanceProfileArn: Optional[InstanceProfileArn] = Optional.Absent,
    slurmConfiguration: Optional[
      zio.aws.pcs.model.UpdateComputeNodeGroupSlurmConfigurationRequest
    ] = Optional.Absent,
    clientToken: Optional[SBClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pcs.model.UpdateComputeNodeGroupRequest = {
    import UpdateComputeNodeGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.UpdateComputeNodeGroupRequest
      .builder()
      .clusterIdentifier(
        ClusterIdentifier.unwrap(clusterIdentifier): java.lang.String
      )
      .computeNodeGroupIdentifier(
        ComputeNodeGroupIdentifier.unwrap(
          computeNodeGroupIdentifier
        ): java.lang.String
      )
      .optionallyWith(
        amiId.map(value => AmiId.unwrap(value): java.lang.String)
      )(_.amiId)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(customLaunchTemplate.map(value => value.buildAwsValue()))(
        _.customLaunchTemplate
      )
      .optionallyWith(purchaseOption.map(value => value.unwrap))(
        _.purchaseOption
      )
      .optionallyWith(spotOptions.map(value => value.buildAwsValue()))(
        _.spotOptions
      )
      .optionallyWith(scalingConfiguration.map(value => value.buildAwsValue()))(
        _.scalingConfiguration
      )
      .optionallyWith(
        iamInstanceProfileArn.map(value =>
          InstanceProfileArn.unwrap(value): java.lang.String
        )
      )(_.iamInstanceProfileArn)
      .optionallyWith(slurmConfiguration.map(value => value.buildAwsValue()))(
        _.slurmConfiguration
      )
      .optionallyWith(
        clientToken.map(value => SBClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.pcs.model.UpdateComputeNodeGroupRequest.ReadOnly =
    zio.aws.pcs.model.UpdateComputeNodeGroupRequest.wrap(buildAwsValue())
}
object UpdateComputeNodeGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pcs.model.UpdateComputeNodeGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.UpdateComputeNodeGroupRequest =
      zio.aws.pcs.model.UpdateComputeNodeGroupRequest(
        clusterIdentifier,
        computeNodeGroupIdentifier,
        amiId.map(value => value),
        subnetIds.map(value => value),
        customLaunchTemplate.map(value => value.asEditable),
        purchaseOption.map(value => value),
        spotOptions.map(value => value.asEditable),
        scalingConfiguration.map(value => value.asEditable),
        iamInstanceProfileArn.map(value => value),
        slurmConfiguration.map(value => value.asEditable),
        clientToken.map(value => value)
      )
    def clusterIdentifier: ClusterIdentifier
    def computeNodeGroupIdentifier: ComputeNodeGroupIdentifier
    def amiId: Optional[AmiId]
    def subnetIds: Optional[List[String]]
    def customLaunchTemplate
        : Optional[zio.aws.pcs.model.CustomLaunchTemplate.ReadOnly]
    def purchaseOption: Optional[zio.aws.pcs.model.PurchaseOption]
    def spotOptions: Optional[zio.aws.pcs.model.SpotOptions.ReadOnly]
    def scalingConfiguration
        : Optional[zio.aws.pcs.model.ScalingConfigurationRequest.ReadOnly]
    def iamInstanceProfileArn: Optional[InstanceProfileArn]
    def slurmConfiguration: Optional[
      zio.aws.pcs.model.UpdateComputeNodeGroupSlurmConfigurationRequest.ReadOnly
    ]
    def clientToken: Optional[SBClientToken]
    def getClusterIdentifier: ZIO[Any, Nothing, ClusterIdentifier] =
      ZIO.succeed(clusterIdentifier)
    def getComputeNodeGroupIdentifier
        : ZIO[Any, Nothing, ComputeNodeGroupIdentifier] =
      ZIO.succeed(computeNodeGroupIdentifier)
    def getAmiId: ZIO[Any, AwsError, AmiId] =
      AwsError.unwrapOptionField("amiId", amiId)
    def getSubnetIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getCustomLaunchTemplate
        : ZIO[Any, AwsError, zio.aws.pcs.model.CustomLaunchTemplate.ReadOnly] =
      AwsError.unwrapOptionField("customLaunchTemplate", customLaunchTemplate)
    def getPurchaseOption
        : ZIO[Any, AwsError, zio.aws.pcs.model.PurchaseOption] =
      AwsError.unwrapOptionField("purchaseOption", purchaseOption)
    def getSpotOptions
        : ZIO[Any, AwsError, zio.aws.pcs.model.SpotOptions.ReadOnly] =
      AwsError.unwrapOptionField("spotOptions", spotOptions)
    def getScalingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.pcs.model.ScalingConfigurationRequest.ReadOnly
    ] = AwsError.unwrapOptionField("scalingConfiguration", scalingConfiguration)
    def getIamInstanceProfileArn: ZIO[Any, AwsError, InstanceProfileArn] =
      AwsError.unwrapOptionField("iamInstanceProfileArn", iamInstanceProfileArn)
    def getSlurmConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.pcs.model.UpdateComputeNodeGroupSlurmConfigurationRequest.ReadOnly
    ] = AwsError.unwrapOptionField("slurmConfiguration", slurmConfiguration)
    def getClientToken: ZIO[Any, AwsError, SBClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.UpdateComputeNodeGroupRequest
  ) extends zio.aws.pcs.model.UpdateComputeNodeGroupRequest.ReadOnly {
    override val clusterIdentifier: ClusterIdentifier =
      zio.aws.pcs.model.primitives.ClusterIdentifier(impl.clusterIdentifier())
    override val computeNodeGroupIdentifier: ComputeNodeGroupIdentifier =
      zio.aws.pcs.model.primitives
        .ComputeNodeGroupIdentifier(impl.computeNodeGroupIdentifier())
    override val amiId: Optional[AmiId] = zio.aws.core.internal
      .optionalFromNullable(impl.amiId())
      .map(value => zio.aws.pcs.model.primitives.AmiId(value))
    override val subnetIds: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val customLaunchTemplate
        : Optional[zio.aws.pcs.model.CustomLaunchTemplate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customLaunchTemplate())
        .map(value => zio.aws.pcs.model.CustomLaunchTemplate.wrap(value))
    override val purchaseOption: Optional[zio.aws.pcs.model.PurchaseOption] =
      zio.aws.core.internal
        .optionalFromNullable(impl.purchaseOption())
        .map(value => zio.aws.pcs.model.PurchaseOption.wrap(value))
    override val spotOptions: Optional[zio.aws.pcs.model.SpotOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.spotOptions())
        .map(value => zio.aws.pcs.model.SpotOptions.wrap(value))
    override val scalingConfiguration
        : Optional[zio.aws.pcs.model.ScalingConfigurationRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scalingConfiguration())
        .map(value => zio.aws.pcs.model.ScalingConfigurationRequest.wrap(value))
    override val iamInstanceProfileArn: Optional[InstanceProfileArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iamInstanceProfileArn())
        .map(value => zio.aws.pcs.model.primitives.InstanceProfileArn(value))
    override val slurmConfiguration: Optional[
      zio.aws.pcs.model.UpdateComputeNodeGroupSlurmConfigurationRequest.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.slurmConfiguration())
      .map(value =>
        zio.aws.pcs.model.UpdateComputeNodeGroupSlurmConfigurationRequest
          .wrap(value)
      )
    override val clientToken: Optional[SBClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.pcs.model.primitives.SBClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.UpdateComputeNodeGroupRequest
  ): zio.aws.pcs.model.UpdateComputeNodeGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
