package zio.aws.pcs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateComputeNodeGroupResponse(
    computeNodeGroup: Optional[zio.aws.pcs.model.ComputeNodeGroup] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pcs.model.UpdateComputeNodeGroupResponse = {
    import UpdateComputeNodeGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.UpdateComputeNodeGroupResponse
      .builder()
      .optionallyWith(computeNodeGroup.map(value => value.buildAwsValue()))(
        _.computeNodeGroup
      )
      .build()
  }
  def asReadOnly: zio.aws.pcs.model.UpdateComputeNodeGroupResponse.ReadOnly =
    zio.aws.pcs.model.UpdateComputeNodeGroupResponse.wrap(buildAwsValue())
}
object UpdateComputeNodeGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pcs.model.UpdateComputeNodeGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.UpdateComputeNodeGroupResponse =
      zio.aws.pcs.model.UpdateComputeNodeGroupResponse(
        computeNodeGroup.map(value => value.asEditable)
      )
    def computeNodeGroup: Optional[zio.aws.pcs.model.ComputeNodeGroup.ReadOnly]
    def getComputeNodeGroup
        : ZIO[Any, AwsError, zio.aws.pcs.model.ComputeNodeGroup.ReadOnly] =
      AwsError.unwrapOptionField("computeNodeGroup", computeNodeGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.UpdateComputeNodeGroupResponse
  ) extends zio.aws.pcs.model.UpdateComputeNodeGroupResponse.ReadOnly {
    override val computeNodeGroup
        : Optional[zio.aws.pcs.model.ComputeNodeGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.computeNodeGroup())
        .map(value => zio.aws.pcs.model.ComputeNodeGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.UpdateComputeNodeGroupResponse
  ): zio.aws.pcs.model.UpdateComputeNodeGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
