package zio.aws.pcs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateComputeNodeGroupSlurmConfigurationRequest(
    slurmCustomSettings: Optional[
      Iterable[zio.aws.pcs.model.SlurmCustomSetting]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pcs.model.UpdateComputeNodeGroupSlurmConfigurationRequest = {
    import UpdateComputeNodeGroupSlurmConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.UpdateComputeNodeGroupSlurmConfigurationRequest
      .builder()
      .optionallyWith(
        slurmCustomSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.slurmCustomSettings)
      .build()
  }
  def asReadOnly
      : zio.aws.pcs.model.UpdateComputeNodeGroupSlurmConfigurationRequest.ReadOnly =
    zio.aws.pcs.model.UpdateComputeNodeGroupSlurmConfigurationRequest
      .wrap(buildAwsValue())
}
object UpdateComputeNodeGroupSlurmConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pcs.model.UpdateComputeNodeGroupSlurmConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pcs.model.UpdateComputeNodeGroupSlurmConfigurationRequest =
      zio.aws.pcs.model.UpdateComputeNodeGroupSlurmConfigurationRequest(
        slurmCustomSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def slurmCustomSettings
        : Optional[List[zio.aws.pcs.model.SlurmCustomSetting.ReadOnly]]
    def getSlurmCustomSettings: ZIO[Any, AwsError, List[
      zio.aws.pcs.model.SlurmCustomSetting.ReadOnly
    ]] = AwsError.unwrapOptionField("slurmCustomSettings", slurmCustomSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.UpdateComputeNodeGroupSlurmConfigurationRequest
  ) extends zio.aws.pcs.model.UpdateComputeNodeGroupSlurmConfigurationRequest.ReadOnly {
    override val slurmCustomSettings
        : Optional[List[zio.aws.pcs.model.SlurmCustomSetting.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.slurmCustomSettings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pcs.model.SlurmCustomSetting.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.UpdateComputeNodeGroupSlurmConfigurationRequest
  ): zio.aws.pcs.model.UpdateComputeNodeGroupSlurmConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
