package zio.aws.pcs.model
import zio.aws.pcs.model.primitives.{
  SBClientToken,
  QueueIdentifier,
  ClusterIdentifier
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateQueueRequest(
    clusterIdentifier: ClusterIdentifier,
    queueIdentifier: QueueIdentifier,
    computeNodeGroupConfigurations: Optional[
      Iterable[zio.aws.pcs.model.ComputeNodeGroupConfiguration]
    ] = Optional.Absent,
    clientToken: Optional[SBClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pcs.model.UpdateQueueRequest = {
    import UpdateQueueRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.UpdateQueueRequest
      .builder()
      .clusterIdentifier(
        ClusterIdentifier.unwrap(clusterIdentifier): java.lang.String
      )
      .queueIdentifier(
        QueueIdentifier.unwrap(queueIdentifier): java.lang.String
      )
      .optionallyWith(
        computeNodeGroupConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.computeNodeGroupConfigurations)
      .optionallyWith(
        clientToken.map(value => SBClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.pcs.model.UpdateQueueRequest.ReadOnly =
    zio.aws.pcs.model.UpdateQueueRequest.wrap(buildAwsValue())
}
object UpdateQueueRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pcs.model.UpdateQueueRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.UpdateQueueRequest =
      zio.aws.pcs.model.UpdateQueueRequest(
        clusterIdentifier,
        queueIdentifier,
        computeNodeGroupConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientToken.map(value => value)
      )
    def clusterIdentifier: ClusterIdentifier
    def queueIdentifier: QueueIdentifier
    def computeNodeGroupConfigurations: Optional[
      List[zio.aws.pcs.model.ComputeNodeGroupConfiguration.ReadOnly]
    ]
    def clientToken: Optional[SBClientToken]
    def getClusterIdentifier: ZIO[Any, Nothing, ClusterIdentifier] =
      ZIO.succeed(clusterIdentifier)
    def getQueueIdentifier: ZIO[Any, Nothing, QueueIdentifier] =
      ZIO.succeed(queueIdentifier)
    def getComputeNodeGroupConfigurations: ZIO[Any, AwsError, List[
      zio.aws.pcs.model.ComputeNodeGroupConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "computeNodeGroupConfigurations",
      computeNodeGroupConfigurations
    )
    def getClientToken: ZIO[Any, AwsError, SBClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.UpdateQueueRequest
  ) extends zio.aws.pcs.model.UpdateQueueRequest.ReadOnly {
    override val clusterIdentifier: ClusterIdentifier =
      zio.aws.pcs.model.primitives.ClusterIdentifier(impl.clusterIdentifier())
    override val queueIdentifier: QueueIdentifier =
      zio.aws.pcs.model.primitives.QueueIdentifier(impl.queueIdentifier())
    override val computeNodeGroupConfigurations: Optional[
      List[zio.aws.pcs.model.ComputeNodeGroupConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.computeNodeGroupConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pcs.model.ComputeNodeGroupConfiguration.wrap(item)
        }.toList
      )
    override val clientToken: Optional[SBClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.pcs.model.primitives.SBClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.UpdateQueueRequest
  ): zio.aws.pcs.model.UpdateQueueRequest.ReadOnly = new Wrapper(impl)
}
