package zio.aws.pcs
import zio.aws.pcs.model.primitives.{
  SubnetId,
  SecurityGroupId,
  TagValue,
  TagKey
}
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.pcs.model.primitives.AmiId.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AmiId extends zio.prelude.Subtype[String]
    type AmiId = zio.aws.pcs.model.primitives.AmiId.Type
    object Arn extends zio.prelude.Subtype[String]
    type Arn = zio.aws.pcs.model.primitives.Arn.Type
    object BootstrapId extends zio.prelude.Subtype[String]
    type BootstrapId = zio.aws.pcs.model.primitives.BootstrapId.Type
    object ClusterIdentifier extends zio.prelude.Subtype[String]
    type ClusterIdentifier = zio.aws.pcs.model.primitives.ClusterIdentifier.Type
    object ClusterName extends zio.prelude.Subtype[String]
    type ClusterName = zio.aws.pcs.model.primitives.ClusterName.Type
    object ClusterSlurmConfigurationRequestScaleDownIdleTimeInSecondsInteger
        extends zio.prelude.Subtype[Int]
    type ClusterSlurmConfigurationRequestScaleDownIdleTimeInSecondsInteger =
      zio.aws.pcs.model.primitives.ClusterSlurmConfigurationRequestScaleDownIdleTimeInSecondsInteger.Type
    object ClusterSlurmConfigurationScaleDownIdleTimeInSecondsInteger
        extends zio.prelude.Subtype[Int]
    type ClusterSlurmConfigurationScaleDownIdleTimeInSecondsInteger =
      zio.aws.pcs.model.primitives.ClusterSlurmConfigurationScaleDownIdleTimeInSecondsInteger.Type
    object ComputeNodeGroupIdentifier extends zio.prelude.Subtype[String]
    type ComputeNodeGroupIdentifier =
      zio.aws.pcs.model.primitives.ComputeNodeGroupIdentifier.Type
    object ComputeNodeGroupName extends zio.prelude.Subtype[String]
    type ComputeNodeGroupName =
      zio.aws.pcs.model.primitives.ComputeNodeGroupName.Type
    object InstanceProfileArn extends zio.prelude.Subtype[String]
    type InstanceProfileArn =
      zio.aws.pcs.model.primitives.InstanceProfileArn.Type
    object MaxResults extends zio.prelude.Subtype[Int]
    type MaxResults = zio.aws.pcs.model.primitives.MaxResults.Type
    object QueueIdentifier extends zio.prelude.Subtype[String]
    type QueueIdentifier = zio.aws.pcs.model.primitives.QueueIdentifier.Type
    object QueueName extends zio.prelude.Subtype[String]
    type QueueName = zio.aws.pcs.model.primitives.QueueName.Type
    object SBClientToken extends zio.prelude.Subtype[String]
    type SBClientToken = zio.aws.pcs.model.primitives.SBClientToken.Type
    object ScalingConfigurationMaxInstanceCountInteger
        extends zio.prelude.Subtype[Int]
    type ScalingConfigurationMaxInstanceCountInteger =
      zio.aws.pcs.model.primitives.ScalingConfigurationMaxInstanceCountInteger.Type
    object ScalingConfigurationMinInstanceCountInteger
        extends zio.prelude.Subtype[Int]
    type ScalingConfigurationMinInstanceCountInteger =
      zio.aws.pcs.model.primitives.ScalingConfigurationMinInstanceCountInteger.Type
    object ScalingConfigurationRequestMaxInstanceCountInteger
        extends zio.prelude.Subtype[Int]
    type ScalingConfigurationRequestMaxInstanceCountInteger =
      zio.aws.pcs.model.primitives.ScalingConfigurationRequestMaxInstanceCountInteger.Type
    object ScalingConfigurationRequestMinInstanceCountInteger
        extends zio.prelude.Subtype[Int]
    type ScalingConfigurationRequestMinInstanceCountInteger =
      zio.aws.pcs.model.primitives.ScalingConfigurationRequestMinInstanceCountInteger.Type
    object SecurityGroupId extends zio.prelude.Subtype[String]
    type SecurityGroupId = zio.aws.pcs.model.primitives.SecurityGroupId.Type
    object SharedSecret extends zio.prelude.Subtype[String]
    type SharedSecret = zio.aws.pcs.model.primitives.SharedSecret.Type
    object SubnetId extends zio.prelude.Subtype[String]
    type SubnetId = zio.aws.pcs.model.primitives.SubnetId.Type
    object SyntheticTimestamp_date_time extends zio.prelude.Subtype[Instant]
    type SyntheticTimestamp_date_time =
      zio.aws.pcs.model.primitives.SyntheticTimestamp_date_time.Type
    object TagKey extends zio.prelude.Subtype[String]
    type TagKey = zio.aws.pcs.model.primitives.TagKey.Type
    object TagValue extends zio.prelude.Subtype[String]
    type TagValue = zio.aws.pcs.model.primitives.TagValue.Type
  }
  type ClusterList = List[zio.aws.pcs.model.ClusterSummary]
  type ComputeNodeGroupConfigurationList =
    List[zio.aws.pcs.model.ComputeNodeGroupConfiguration]
  type ComputeNodeGroupList = List[zio.aws.pcs.model.ComputeNodeGroupSummary]
  type Endpoints = List[zio.aws.pcs.model.Endpoint]
  type ErrorInfoList = List[zio.aws.pcs.model.ErrorInfo]
  type InstanceList = List[zio.aws.pcs.model.InstanceConfig]
  type QueueList = List[zio.aws.pcs.model.QueueSummary]
  type RequestTagMap = Map[TagKey, TagValue]
  type ResponseTagMap = Map[TagKey, TagValue]
  type SecurityGroupIdList = List[SecurityGroupId]
  type SlurmCustomSettings = List[zio.aws.pcs.model.SlurmCustomSetting]
  type StringList = List[String]
  type SubnetIdList = List[SubnetId]
  type TagKeys = List[TagKey]
}
