package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{
  ParameterName,
  ParameterValue,
  Date,
  Arn,
  TrainingInputMode,
  Name
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Algorithm(
    name: Option[Name] = None,
    algorithmArn: Option[Arn] = None,
    algorithmImage: Option[zio.aws.personalize.model.AlgorithmImage] = None,
    defaultHyperParameters: Option[Map[ParameterName, ParameterValue]] = None,
    defaultHyperParameterRanges: Option[
      zio.aws.personalize.model.DefaultHyperParameterRanges
    ] = None,
    defaultResourceConfig: Option[Map[ParameterName, ParameterValue]] = None,
    trainingInputMode: Option[TrainingInputMode] = None,
    roleArn: Option[Arn] = None,
    creationDateTime: Option[Date] = None,
    lastUpdatedDateTime: Option[Date] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.Algorithm = {
    import Algorithm.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.Algorithm
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        algorithmArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.algorithmArn)
      .optionallyWith(algorithmImage.map(value => value.buildAwsValue()))(
        _.algorithmImage
      )
      .optionallyWith(
        defaultHyperParameters.map(value =>
          value
            .map({ case (key, value) =>
              (ParameterName.unwrap(key): java.lang.String) -> (ParameterValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.defaultHyperParameters)
      .optionallyWith(
        defaultHyperParameterRanges.map(value => value.buildAwsValue())
      )(_.defaultHyperParameterRanges)
      .optionallyWith(
        defaultResourceConfig.map(value =>
          value
            .map({ case (key, value) =>
              (ParameterName.unwrap(key): java.lang.String) -> (ParameterValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.defaultResourceConfig)
      .optionallyWith(
        trainingInputMode.map(value =>
          TrainingInputMode.unwrap(value): java.lang.String
        )
      )(_.trainingInputMode)
      .optionallyWith(
        roleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.Algorithm.ReadOnly =
    zio.aws.personalize.model.Algorithm.wrap(buildAwsValue())
}
object Algorithm {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.Algorithm
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.Algorithm =
      zio.aws.personalize.model.Algorithm(
        name.map(value => value),
        algorithmArn.map(value => value),
        algorithmImage.map(value => value.asEditable),
        defaultHyperParameters.map(value => value),
        defaultHyperParameterRanges.map(value => value.asEditable),
        defaultResourceConfig.map(value => value),
        trainingInputMode.map(value => value),
        roleArn.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value)
      )
    def name: Option[Name]
    def algorithmArn: Option[Arn]
    def algorithmImage
        : Option[zio.aws.personalize.model.AlgorithmImage.ReadOnly]
    def defaultHyperParameters: Option[Map[ParameterName, ParameterValue]]
    def defaultHyperParameterRanges
        : Option[zio.aws.personalize.model.DefaultHyperParameterRanges.ReadOnly]
    def defaultResourceConfig: Option[Map[ParameterName, ParameterValue]]
    def trainingInputMode: Option[TrainingInputMode]
    def roleArn: Option[Arn]
    def creationDateTime: Option[Date]
    def lastUpdatedDateTime: Option[Date]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getAlgorithmArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("algorithmArn", algorithmArn)
    def getAlgorithmImage: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.AlgorithmImage.ReadOnly
    ] = AwsError.unwrapOptionField("algorithmImage", algorithmImage)
    def getDefaultHyperParameters
        : ZIO[Any, AwsError, Map[ParameterName, ParameterValue]] = AwsError
      .unwrapOptionField("defaultHyperParameters", defaultHyperParameters)
    def getDefaultHyperParameterRanges: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.DefaultHyperParameterRanges.ReadOnly
    ] = AwsError.unwrapOptionField(
      "defaultHyperParameterRanges",
      defaultHyperParameterRanges
    )
    def getDefaultResourceConfig
        : ZIO[Any, AwsError, Map[ParameterName, ParameterValue]] =
      AwsError.unwrapOptionField("defaultResourceConfig", defaultResourceConfig)
    def getTrainingInputMode: ZIO[Any, AwsError, TrainingInputMode] =
      AwsError.unwrapOptionField("trainingInputMode", trainingInputMode)
    def getRoleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.Algorithm
  ) extends zio.aws.personalize.model.Algorithm.ReadOnly {
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.personalize.model.primitives.Name(value))
    override val algorithmArn: Option[Arn] = scala
      .Option(impl.algorithmArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val algorithmImage
        : Option[zio.aws.personalize.model.AlgorithmImage.ReadOnly] = scala
      .Option(impl.algorithmImage())
      .map(value => zio.aws.personalize.model.AlgorithmImage.wrap(value))
    override val defaultHyperParameters
        : Option[Map[ParameterName, ParameterValue]] = scala
      .Option(impl.defaultHyperParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.personalize.model.primitives.ParameterName(
              key
            ) -> zio.aws.personalize.model.primitives.ParameterValue(value)
          })
          .toMap
      )
    override val defaultHyperParameterRanges: Option[
      zio.aws.personalize.model.DefaultHyperParameterRanges.ReadOnly
    ] = scala
      .Option(impl.defaultHyperParameterRanges())
      .map(value =>
        zio.aws.personalize.model.DefaultHyperParameterRanges.wrap(value)
      )
    override val defaultResourceConfig
        : Option[Map[ParameterName, ParameterValue]] = scala
      .Option(impl.defaultResourceConfig())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.personalize.model.primitives.ParameterName(
              key
            ) -> zio.aws.personalize.model.primitives.ParameterValue(value)
          })
          .toMap
      )
    override val trainingInputMode: Option[TrainingInputMode] = scala
      .Option(impl.trainingInputMode())
      .map(value =>
        zio.aws.personalize.model.primitives.TrainingInputMode(value)
      )
    override val roleArn: Option[Arn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val creationDateTime: Option[Date] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val lastUpdatedDateTime: Option[Date] = scala
      .Option(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.Algorithm
  ): zio.aws.personalize.model.Algorithm.ReadOnly = new Wrapper(impl)
}
