package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{DockerURI, Name}
import scala.jdk.CollectionConverters.*
final case class AlgorithmImage(
    name: Option[Name] = None,
    dockerURI: DockerURI
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.AlgorithmImage = {
    import AlgorithmImage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.AlgorithmImage
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .dockerURI(DockerURI.unwrap(dockerURI): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.AlgorithmImage.ReadOnly =
    zio.aws.personalize.model.AlgorithmImage.wrap(buildAwsValue())
}
object AlgorithmImage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.AlgorithmImage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.AlgorithmImage =
      zio.aws.personalize.model
        .AlgorithmImage(name.map(value => value), dockerURI)
    def name: Option[Name]
    def dockerURI: DockerURI
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getDockerURI: ZIO[Any, Nothing, DockerURI] = ZIO.succeed(dockerURI)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.AlgorithmImage
  ) extends zio.aws.personalize.model.AlgorithmImage.ReadOnly {
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.personalize.model.primitives.Name(value))
    override val dockerURI: DockerURI =
      zio.aws.personalize.model.primitives.DockerURI(impl.dockerURI())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.AlgorithmImage
  ): zio.aws.personalize.model.AlgorithmImage.ReadOnly = new Wrapper(impl)
}
