package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class AutoMLResult(bestRecipeArn: Option[Arn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.AutoMLResult = {
    import AutoMLResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.AutoMLResult
      .builder()
      .optionallyWith(
        bestRecipeArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.bestRecipeArn)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.AutoMLResult.ReadOnly =
    zio.aws.personalize.model.AutoMLResult.wrap(buildAwsValue())
}
object AutoMLResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.AutoMLResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.AutoMLResult =
      zio.aws.personalize.model.AutoMLResult(bestRecipeArn.map(value => value))
    def bestRecipeArn: Option[Arn]
    def getBestRecipeArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("bestRecipeArn", bestRecipeArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.AutoMLResult
  ) extends zio.aws.personalize.model.AutoMLResult.ReadOnly {
    override val bestRecipeArn: Option[Arn] = scala
      .Option(impl.bestRecipeArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.AutoMLResult
  ): zio.aws.personalize.model.AutoMLResult.ReadOnly = new Wrapper(impl)
}
