package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{
  Status,
  Date,
  FailureReason,
  Arn,
  Name
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class BatchInferenceJobSummary(
    batchInferenceJobArn: Option[Arn] = None,
    jobName: Option[Name] = None,
    status: Option[Status] = None,
    creationDateTime: Option[Date] = None,
    lastUpdatedDateTime: Option[Date] = None,
    failureReason: Option[FailureReason] = None,
    solutionVersionArn: Option[Arn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.BatchInferenceJobSummary = {
    import BatchInferenceJobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.BatchInferenceJobSummary
      .builder()
      .optionallyWith(
        batchInferenceJobArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.batchInferenceJobArn)
      .optionallyWith(
        jobName.map(value => Name.unwrap(value): java.lang.String)
      )(_.jobName)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        solutionVersionArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.solutionVersionArn)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.BatchInferenceJobSummary.ReadOnly =
    zio.aws.personalize.model.BatchInferenceJobSummary.wrap(buildAwsValue())
}
object BatchInferenceJobSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.BatchInferenceJobSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.BatchInferenceJobSummary =
      zio.aws.personalize.model.BatchInferenceJobSummary(
        batchInferenceJobArn.map(value => value),
        jobName.map(value => value),
        status.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value),
        failureReason.map(value => value),
        solutionVersionArn.map(value => value)
      )
    def batchInferenceJobArn: Option[Arn]
    def jobName: Option[Name]
    def status: Option[Status]
    def creationDateTime: Option[Date]
    def lastUpdatedDateTime: Option[Date]
    def failureReason: Option[FailureReason]
    def solutionVersionArn: Option[Arn]
    def getBatchInferenceJobArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("batchInferenceJobArn", batchInferenceJobArn)
    def getJobName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("jobName", jobName)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getSolutionVersionArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("solutionVersionArn", solutionVersionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.BatchInferenceJobSummary
  ) extends zio.aws.personalize.model.BatchInferenceJobSummary.ReadOnly {
    override val batchInferenceJobArn: Option[Arn] = scala
      .Option(impl.batchInferenceJobArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val jobName: Option[Name] = scala
      .Option(impl.jobName())
      .map(value => zio.aws.personalize.model.primitives.Name(value))
    override val status: Option[Status] = scala
      .Option(impl.status())
      .map(value => zio.aws.personalize.model.primitives.Status(value))
    override val creationDateTime: Option[Date] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val lastUpdatedDateTime: Option[Date] = scala
      .Option(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val failureReason: Option[FailureReason] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.personalize.model.primitives.FailureReason(value))
    override val solutionVersionArn: Option[Arn] = scala
      .Option(impl.solutionVersionArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.BatchInferenceJobSummary
  ): zio.aws.personalize.model.BatchInferenceJobSummary.ReadOnly = new Wrapper(
    impl
  )
}
