package zio.aws.personalize.model
import java.time.Instant
import zio.aws.personalize.model.primitives.{
  Status,
  RoleArn,
  Date,
  FailureReason,
  Arn,
  NumBatchResults,
  Name
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class BatchSegmentJob(
    jobName: Option[Name] = None,
    batchSegmentJobArn: Option[Arn] = None,
    filterArn: Option[Arn] = None,
    failureReason: Option[FailureReason] = None,
    solutionVersionArn: Option[Arn] = None,
    numResults: Option[NumBatchResults] = None,
    jobInput: Option[zio.aws.personalize.model.BatchSegmentJobInput] = None,
    jobOutput: Option[zio.aws.personalize.model.BatchSegmentJobOutput] = None,
    roleArn: Option[RoleArn] = None,
    status: Option[Status] = None,
    creationDateTime: Option[Date] = None,
    lastUpdatedDateTime: Option[Date] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.BatchSegmentJob = {
    import BatchSegmentJob.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.BatchSegmentJob
      .builder()
      .optionallyWith(
        jobName.map(value => Name.unwrap(value): java.lang.String)
      )(_.jobName)
      .optionallyWith(
        batchSegmentJobArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.batchSegmentJobArn)
      .optionallyWith(
        filterArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.filterArn)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        solutionVersionArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.solutionVersionArn)
      .optionallyWith(
        numResults.map(value => NumBatchResults.unwrap(value): Integer)
      )(_.numResults)
      .optionallyWith(jobInput.map(value => value.buildAwsValue()))(_.jobInput)
      .optionallyWith(jobOutput.map(value => value.buildAwsValue()))(
        _.jobOutput
      )
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.BatchSegmentJob.ReadOnly =
    zio.aws.personalize.model.BatchSegmentJob.wrap(buildAwsValue())
}
object BatchSegmentJob {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.BatchSegmentJob
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.BatchSegmentJob =
      zio.aws.personalize.model.BatchSegmentJob(
        jobName.map(value => value),
        batchSegmentJobArn.map(value => value),
        filterArn.map(value => value),
        failureReason.map(value => value),
        solutionVersionArn.map(value => value),
        numResults.map(value => value),
        jobInput.map(value => value.asEditable),
        jobOutput.map(value => value.asEditable),
        roleArn.map(value => value),
        status.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value)
      )
    def jobName: Option[Name]
    def batchSegmentJobArn: Option[Arn]
    def filterArn: Option[Arn]
    def failureReason: Option[FailureReason]
    def solutionVersionArn: Option[Arn]
    def numResults: Option[NumBatchResults]
    def jobInput
        : Option[zio.aws.personalize.model.BatchSegmentJobInput.ReadOnly]
    def jobOutput
        : Option[zio.aws.personalize.model.BatchSegmentJobOutput.ReadOnly]
    def roleArn: Option[RoleArn]
    def status: Option[Status]
    def creationDateTime: Option[Date]
    def lastUpdatedDateTime: Option[Date]
    def getJobName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("jobName", jobName)
    def getBatchSegmentJobArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("batchSegmentJobArn", batchSegmentJobArn)
    def getFilterArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("filterArn", filterArn)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getSolutionVersionArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("solutionVersionArn", solutionVersionArn)
    def getNumResults: ZIO[Any, AwsError, NumBatchResults] =
      AwsError.unwrapOptionField("numResults", numResults)
    def getJobInput: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.BatchSegmentJobInput.ReadOnly
    ] = AwsError.unwrapOptionField("jobInput", jobInput)
    def getJobOutput: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.BatchSegmentJobOutput.ReadOnly
    ] = AwsError.unwrapOptionField("jobOutput", jobOutput)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.BatchSegmentJob
  ) extends zio.aws.personalize.model.BatchSegmentJob.ReadOnly {
    override val jobName: Option[Name] = scala
      .Option(impl.jobName())
      .map(value => zio.aws.personalize.model.primitives.Name(value))
    override val batchSegmentJobArn: Option[Arn] = scala
      .Option(impl.batchSegmentJobArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val filterArn: Option[Arn] = scala
      .Option(impl.filterArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val failureReason: Option[FailureReason] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.personalize.model.primitives.FailureReason(value))
    override val solutionVersionArn: Option[Arn] = scala
      .Option(impl.solutionVersionArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val numResults: Option[NumBatchResults] = scala
      .Option(impl.numResults())
      .map(value => zio.aws.personalize.model.primitives.NumBatchResults(value))
    override val jobInput
        : Option[zio.aws.personalize.model.BatchSegmentJobInput.ReadOnly] =
      scala
        .Option(impl.jobInput())
        .map(value =>
          zio.aws.personalize.model.BatchSegmentJobInput.wrap(value)
        )
    override val jobOutput
        : Option[zio.aws.personalize.model.BatchSegmentJobOutput.ReadOnly] =
      scala
        .Option(impl.jobOutput())
        .map(value =>
          zio.aws.personalize.model.BatchSegmentJobOutput.wrap(value)
        )
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.personalize.model.primitives.RoleArn(value))
    override val status: Option[Status] = scala
      .Option(impl.status())
      .map(value => zio.aws.personalize.model.primitives.Status(value))
    override val creationDateTime: Option[Date] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val lastUpdatedDateTime: Option[Date] = scala
      .Option(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.BatchSegmentJob
  ): zio.aws.personalize.model.BatchSegmentJob.ReadOnly = new Wrapper(impl)
}
