package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchSegmentJobInput(
    s3DataSource: zio.aws.personalize.model.S3DataConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.BatchSegmentJobInput = {
    import BatchSegmentJobInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.BatchSegmentJobInput
      .builder()
      .s3DataSource(s3DataSource.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.BatchSegmentJobInput.ReadOnly =
    zio.aws.personalize.model.BatchSegmentJobInput.wrap(buildAwsValue())
}
object BatchSegmentJobInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.BatchSegmentJobInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.BatchSegmentJobInput =
      zio.aws.personalize.model.BatchSegmentJobInput(s3DataSource.asEditable)
    def s3DataSource: zio.aws.personalize.model.S3DataConfig.ReadOnly
    def getS3DataSource
        : ZIO[Any, Nothing, zio.aws.personalize.model.S3DataConfig.ReadOnly] =
      ZIO.succeed(s3DataSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.BatchSegmentJobInput
  ) extends zio.aws.personalize.model.BatchSegmentJobInput.ReadOnly {
    override val s3DataSource: zio.aws.personalize.model.S3DataConfig.ReadOnly =
      zio.aws.personalize.model.S3DataConfig.wrap(impl.s3DataSource())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.BatchSegmentJobInput
  ): zio.aws.personalize.model.BatchSegmentJobInput.ReadOnly = new Wrapper(impl)
}
