package zio.aws.personalize.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{
  RoleArn,
  NumBatchResults,
  Arn,
  Name
}
import scala.jdk.CollectionConverters.*
final case class CreateBatchSegmentJobRequest(
    jobName: Name,
    solutionVersionArn: Arn,
    filterArn: Option[Arn] = None,
    numResults: Option[NumBatchResults] = None,
    jobInput: zio.aws.personalize.model.BatchSegmentJobInput,
    jobOutput: zio.aws.personalize.model.BatchSegmentJobOutput,
    roleArn: RoleArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.CreateBatchSegmentJobRequest = {
    import CreateBatchSegmentJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.CreateBatchSegmentJobRequest
      .builder()
      .jobName(Name.unwrap(jobName): java.lang.String)
      .solutionVersionArn(Arn.unwrap(solutionVersionArn): java.lang.String)
      .optionallyWith(
        filterArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.filterArn)
      .optionallyWith(
        numResults.map(value => NumBatchResults.unwrap(value): Integer)
      )(_.numResults)
      .jobInput(jobInput.buildAwsValue())
      .jobOutput(jobOutput.buildAwsValue())
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.CreateBatchSegmentJobRequest.ReadOnly =
    zio.aws.personalize.model.CreateBatchSegmentJobRequest.wrap(buildAwsValue())
}
object CreateBatchSegmentJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.CreateBatchSegmentJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.CreateBatchSegmentJobRequest =
      zio.aws.personalize.model.CreateBatchSegmentJobRequest(
        jobName,
        solutionVersionArn,
        filterArn.map(value => value),
        numResults.map(value => value),
        jobInput.asEditable,
        jobOutput.asEditable,
        roleArn
      )
    def jobName: Name
    def solutionVersionArn: Arn
    def filterArn: Option[Arn]
    def numResults: Option[NumBatchResults]
    def jobInput: zio.aws.personalize.model.BatchSegmentJobInput.ReadOnly
    def jobOutput: zio.aws.personalize.model.BatchSegmentJobOutput.ReadOnly
    def roleArn: RoleArn
    def getJobName: ZIO[Any, Nothing, Name] = ZIO.succeed(jobName)
    def getSolutionVersionArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(solutionVersionArn)
    def getFilterArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("filterArn", filterArn)
    def getNumResults: ZIO[Any, AwsError, NumBatchResults] =
      AwsError.unwrapOptionField("numResults", numResults)
    def getJobInput: ZIO[
      Any,
      Nothing,
      zio.aws.personalize.model.BatchSegmentJobInput.ReadOnly
    ] = ZIO.succeed(jobInput)
    def getJobOutput: ZIO[
      Any,
      Nothing,
      zio.aws.personalize.model.BatchSegmentJobOutput.ReadOnly
    ] = ZIO.succeed(jobOutput)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.CreateBatchSegmentJobRequest
  ) extends zio.aws.personalize.model.CreateBatchSegmentJobRequest.ReadOnly {
    override val jobName: Name =
      zio.aws.personalize.model.primitives.Name(impl.jobName())
    override val solutionVersionArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.solutionVersionArn())
    override val filterArn: Option[Arn] = scala
      .Option(impl.filterArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val numResults: Option[NumBatchResults] = scala
      .Option(impl.numResults())
      .map(value => zio.aws.personalize.model.primitives.NumBatchResults(value))
    override val jobInput
        : zio.aws.personalize.model.BatchSegmentJobInput.ReadOnly =
      zio.aws.personalize.model.BatchSegmentJobInput.wrap(impl.jobInput())
    override val jobOutput
        : zio.aws.personalize.model.BatchSegmentJobOutput.ReadOnly =
      zio.aws.personalize.model.BatchSegmentJobOutput.wrap(impl.jobOutput())
    override val roleArn: RoleArn =
      zio.aws.personalize.model.primitives.RoleArn(impl.roleArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.CreateBatchSegmentJobRequest
  ): zio.aws.personalize.model.CreateBatchSegmentJobRequest.ReadOnly =
    new Wrapper(impl)
}
