package zio.aws.personalize.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{TransactionsPerSecond, Arn, Name}
import scala.jdk.CollectionConverters.*
final case class CreateCampaignRequest(
    name: Name,
    solutionVersionArn: Arn,
    minProvisionedTPS: Option[TransactionsPerSecond] = None,
    campaignConfig: Option[zio.aws.personalize.model.CampaignConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.CreateCampaignRequest = {
    import CreateCampaignRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.CreateCampaignRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .solutionVersionArn(Arn.unwrap(solutionVersionArn): java.lang.String)
      .optionallyWith(
        minProvisionedTPS.map(value =>
          TransactionsPerSecond.unwrap(value): Integer
        )
      )(_.minProvisionedTPS)
      .optionallyWith(campaignConfig.map(value => value.buildAwsValue()))(
        _.campaignConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.CreateCampaignRequest.ReadOnly =
    zio.aws.personalize.model.CreateCampaignRequest.wrap(buildAwsValue())
}
object CreateCampaignRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.CreateCampaignRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.CreateCampaignRequest =
      zio.aws.personalize.model.CreateCampaignRequest(
        name,
        solutionVersionArn,
        minProvisionedTPS.map(value => value),
        campaignConfig.map(value => value.asEditable)
      )
    def name: Name
    def solutionVersionArn: Arn
    def minProvisionedTPS: Option[TransactionsPerSecond]
    def campaignConfig
        : Option[zio.aws.personalize.model.CampaignConfig.ReadOnly]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getSolutionVersionArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(solutionVersionArn)
    def getMinProvisionedTPS: ZIO[Any, AwsError, TransactionsPerSecond] =
      AwsError.unwrapOptionField("minProvisionedTPS", minProvisionedTPS)
    def getCampaignConfig: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.CampaignConfig.ReadOnly
    ] = AwsError.unwrapOptionField("campaignConfig", campaignConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.CreateCampaignRequest
  ) extends zio.aws.personalize.model.CreateCampaignRequest.ReadOnly {
    override val name: Name =
      zio.aws.personalize.model.primitives.Name(impl.name())
    override val solutionVersionArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.solutionVersionArn())
    override val minProvisionedTPS: Option[TransactionsPerSecond] = scala
      .Option(impl.minProvisionedTPS())
      .map(value =>
        zio.aws.personalize.model.primitives.TransactionsPerSecond(value)
      )
    override val campaignConfig
        : Option[zio.aws.personalize.model.CampaignConfig.ReadOnly] = scala
      .Option(impl.campaignConfig())
      .map(value => zio.aws.personalize.model.CampaignConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.CreateCampaignRequest
  ): zio.aws.personalize.model.CreateCampaignRequest.ReadOnly = new Wrapper(
    impl
  )
}
