package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{RoleArn, Arn, Name}
import scala.jdk.CollectionConverters.*
final case class CreateDatasetExportJobRequest(
    jobName: Name,
    datasetArn: Arn,
    ingestionMode: Option[zio.aws.personalize.model.IngestionMode] = None,
    roleArn: RoleArn,
    jobOutput: zio.aws.personalize.model.DatasetExportJobOutput
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.CreateDatasetExportJobRequest = {
    import CreateDatasetExportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.CreateDatasetExportJobRequest
      .builder()
      .jobName(Name.unwrap(jobName): java.lang.String)
      .datasetArn(Arn.unwrap(datasetArn): java.lang.String)
      .optionallyWith(ingestionMode.map(value => value.unwrap))(_.ingestionMode)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .jobOutput(jobOutput.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.CreateDatasetExportJobRequest.ReadOnly =
    zio.aws.personalize.model.CreateDatasetExportJobRequest
      .wrap(buildAwsValue())
}
object CreateDatasetExportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.CreateDatasetExportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.CreateDatasetExportJobRequest =
      zio.aws.personalize.model.CreateDatasetExportJobRequest(
        jobName,
        datasetArn,
        ingestionMode.map(value => value),
        roleArn,
        jobOutput.asEditable
      )
    def jobName: Name
    def datasetArn: Arn
    def ingestionMode: Option[zio.aws.personalize.model.IngestionMode]
    def roleArn: RoleArn
    def jobOutput: zio.aws.personalize.model.DatasetExportJobOutput.ReadOnly
    def getJobName: ZIO[Any, Nothing, Name] = ZIO.succeed(jobName)
    def getDatasetArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(datasetArn)
    def getIngestionMode
        : ZIO[Any, AwsError, zio.aws.personalize.model.IngestionMode] =
      AwsError.unwrapOptionField("ingestionMode", ingestionMode)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getJobOutput: ZIO[
      Any,
      Nothing,
      zio.aws.personalize.model.DatasetExportJobOutput.ReadOnly
    ] = ZIO.succeed(jobOutput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.CreateDatasetExportJobRequest
  ) extends zio.aws.personalize.model.CreateDatasetExportJobRequest.ReadOnly {
    override val jobName: Name =
      zio.aws.personalize.model.primitives.Name(impl.jobName())
    override val datasetArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.datasetArn())
    override val ingestionMode
        : Option[zio.aws.personalize.model.IngestionMode] = scala
      .Option(impl.ingestionMode())
      .map(value => zio.aws.personalize.model.IngestionMode.wrap(value))
    override val roleArn: RoleArn =
      zio.aws.personalize.model.primitives.RoleArn(impl.roleArn())
    override val jobOutput
        : zio.aws.personalize.model.DatasetExportJobOutput.ReadOnly =
      zio.aws.personalize.model.DatasetExportJobOutput.wrap(impl.jobOutput())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.CreateDatasetExportJobRequest
  ): zio.aws.personalize.model.CreateDatasetExportJobRequest.ReadOnly =
    new Wrapper(impl)
}
