package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{KmsKeyArn, RoleArn, Name}
import scala.jdk.CollectionConverters.*
final case class CreateDatasetGroupRequest(
    name: Name,
    roleArn: Option[RoleArn] = None,
    kmsKeyArn: Option[KmsKeyArn] = None,
    domain: Option[zio.aws.personalize.model.Domain] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.CreateDatasetGroupRequest = {
    import CreateDatasetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.CreateDatasetGroupRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        kmsKeyArn.map(value => KmsKeyArn.unwrap(value): java.lang.String)
      )(_.kmsKeyArn)
      .optionallyWith(domain.map(value => value.unwrap))(_.domain)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.CreateDatasetGroupRequest.ReadOnly =
    zio.aws.personalize.model.CreateDatasetGroupRequest.wrap(buildAwsValue())
}
object CreateDatasetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.CreateDatasetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.CreateDatasetGroupRequest =
      zio.aws.personalize.model.CreateDatasetGroupRequest(
        name,
        roleArn.map(value => value),
        kmsKeyArn.map(value => value),
        domain.map(value => value)
      )
    def name: Name
    def roleArn: Option[RoleArn]
    def kmsKeyArn: Option[KmsKeyArn]
    def domain: Option[zio.aws.personalize.model.Domain]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getKmsKeyArn: ZIO[Any, AwsError, KmsKeyArn] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
    def getDomain: ZIO[Any, AwsError, zio.aws.personalize.model.Domain] =
      AwsError.unwrapOptionField("domain", domain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.CreateDatasetGroupRequest
  ) extends zio.aws.personalize.model.CreateDatasetGroupRequest.ReadOnly {
    override val name: Name =
      zio.aws.personalize.model.primitives.Name(impl.name())
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.personalize.model.primitives.RoleArn(value))
    override val kmsKeyArn: Option[KmsKeyArn] = scala
      .Option(impl.kmsKeyArn())
      .map(value => zio.aws.personalize.model.primitives.KmsKeyArn(value))
    override val domain: Option[zio.aws.personalize.model.Domain] = scala
      .Option(impl.domain())
      .map(value => zio.aws.personalize.model.Domain.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.CreateDatasetGroupRequest
  ): zio.aws.personalize.model.CreateDatasetGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
