package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class CreateDatasetGroupResponse(
    datasetGroupArn: Option[Arn] = None,
    domain: Option[zio.aws.personalize.model.Domain] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.CreateDatasetGroupResponse = {
    import CreateDatasetGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.CreateDatasetGroupResponse
      .builder()
      .optionallyWith(
        datasetGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetGroupArn)
      .optionallyWith(domain.map(value => value.unwrap))(_.domain)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.CreateDatasetGroupResponse.ReadOnly =
    zio.aws.personalize.model.CreateDatasetGroupResponse.wrap(buildAwsValue())
}
object CreateDatasetGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.CreateDatasetGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.CreateDatasetGroupResponse =
      zio.aws.personalize.model.CreateDatasetGroupResponse(
        datasetGroupArn.map(value => value),
        domain.map(value => value)
      )
    def datasetGroupArn: Option[Arn]
    def domain: Option[zio.aws.personalize.model.Domain]
    def getDatasetGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetGroupArn", datasetGroupArn)
    def getDomain: ZIO[Any, AwsError, zio.aws.personalize.model.Domain] =
      AwsError.unwrapOptionField("domain", domain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.CreateDatasetGroupResponse
  ) extends zio.aws.personalize.model.CreateDatasetGroupResponse.ReadOnly {
    override val datasetGroupArn: Option[Arn] = scala
      .Option(impl.datasetGroupArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val domain: Option[zio.aws.personalize.model.Domain] = scala
      .Option(impl.domain())
      .map(value => zio.aws.personalize.model.Domain.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.CreateDatasetGroupResponse
  ): zio.aws.personalize.model.CreateDatasetGroupResponse.ReadOnly =
    new Wrapper(impl)
}
