package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalize.model.primitives.{Arn, Name}
import scala.jdk.CollectionConverters.*
final case class CreateEventTrackerRequest(name: Name, datasetGroupArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.CreateEventTrackerRequest = {
    import CreateEventTrackerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.CreateEventTrackerRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .datasetGroupArn(Arn.unwrap(datasetGroupArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.CreateEventTrackerRequest.ReadOnly =
    zio.aws.personalize.model.CreateEventTrackerRequest.wrap(buildAwsValue())
}
object CreateEventTrackerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.CreateEventTrackerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.CreateEventTrackerRequest =
      zio.aws.personalize.model.CreateEventTrackerRequest(name, datasetGroupArn)
    def name: Name
    def datasetGroupArn: Arn
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getDatasetGroupArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(datasetGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.CreateEventTrackerRequest
  ) extends zio.aws.personalize.model.CreateEventTrackerRequest.ReadOnly {
    override val name: Name =
      zio.aws.personalize.model.primitives.Name(impl.name())
    override val datasetGroupArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.datasetGroupArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.CreateEventTrackerRequest
  ): zio.aws.personalize.model.CreateEventTrackerRequest.ReadOnly = new Wrapper(
    impl
  )
}
