package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalize.model.primitives.{FilterExpression, Arn, Name}
import scala.jdk.CollectionConverters.*
final case class CreateFilterRequest(
    name: Name,
    datasetGroupArn: Arn,
    filterExpression: FilterExpression
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.CreateFilterRequest = {
    import CreateFilterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.CreateFilterRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .datasetGroupArn(Arn.unwrap(datasetGroupArn): java.lang.String)
      .filterExpression(
        FilterExpression.unwrap(filterExpression): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.CreateFilterRequest.ReadOnly =
    zio.aws.personalize.model.CreateFilterRequest.wrap(buildAwsValue())
}
object CreateFilterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.CreateFilterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.CreateFilterRequest =
      zio.aws.personalize.model
        .CreateFilterRequest(name, datasetGroupArn, filterExpression)
    def name: Name
    def datasetGroupArn: Arn
    def filterExpression: FilterExpression
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getDatasetGroupArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(datasetGroupArn)
    def getFilterExpression: ZIO[Any, Nothing, FilterExpression] =
      ZIO.succeed(filterExpression)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.CreateFilterRequest
  ) extends zio.aws.personalize.model.CreateFilterRequest.ReadOnly {
    override val name: Name =
      zio.aws.personalize.model.primitives.Name(impl.name())
    override val datasetGroupArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.datasetGroupArn())
    override val filterExpression: FilterExpression =
      zio.aws.personalize.model.primitives
        .FilterExpression(impl.filterExpression())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.CreateFilterRequest
  ): zio.aws.personalize.model.CreateFilterRequest.ReadOnly = new Wrapper(impl)
}
