package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{Arn, Name}
import scala.jdk.CollectionConverters.*
final case class CreateRecommenderRequest(
    name: Name,
    datasetGroupArn: Arn,
    recipeArn: Arn,
    recommenderConfig: Option[zio.aws.personalize.model.RecommenderConfig] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.CreateRecommenderRequest = {
    import CreateRecommenderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.CreateRecommenderRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .datasetGroupArn(Arn.unwrap(datasetGroupArn): java.lang.String)
      .recipeArn(Arn.unwrap(recipeArn): java.lang.String)
      .optionallyWith(recommenderConfig.map(value => value.buildAwsValue()))(
        _.recommenderConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.CreateRecommenderRequest.ReadOnly =
    zio.aws.personalize.model.CreateRecommenderRequest.wrap(buildAwsValue())
}
object CreateRecommenderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.CreateRecommenderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.CreateRecommenderRequest =
      zio.aws.personalize.model.CreateRecommenderRequest(
        name,
        datasetGroupArn,
        recipeArn,
        recommenderConfig.map(value => value.asEditable)
      )
    def name: Name
    def datasetGroupArn: Arn
    def recipeArn: Arn
    def recommenderConfig
        : Option[zio.aws.personalize.model.RecommenderConfig.ReadOnly]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getDatasetGroupArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(datasetGroupArn)
    def getRecipeArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(recipeArn)
    def getRecommenderConfig: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.RecommenderConfig.ReadOnly
    ] = AwsError.unwrapOptionField("recommenderConfig", recommenderConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.CreateRecommenderRequest
  ) extends zio.aws.personalize.model.CreateRecommenderRequest.ReadOnly {
    override val name: Name =
      zio.aws.personalize.model.primitives.Name(impl.name())
    override val datasetGroupArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.datasetGroupArn())
    override val recipeArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.recipeArn())
    override val recommenderConfig
        : Option[zio.aws.personalize.model.RecommenderConfig.ReadOnly] = scala
      .Option(impl.recommenderConfig())
      .map(value => zio.aws.personalize.model.RecommenderConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.CreateRecommenderRequest
  ): zio.aws.personalize.model.CreateRecommenderRequest.ReadOnly = new Wrapper(
    impl
  )
}
