package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{
  EventType,
  Arn,
  PerformAutoML,
  Name
}
import scala.jdk.CollectionConverters.*
final case class CreateSolutionRequest(
    name: Name,
    performHPO: Option[Boolean] = None,
    performAutoML: Option[PerformAutoML] = None,
    recipeArn: Option[Arn] = None,
    datasetGroupArn: Arn,
    eventType: Option[EventType] = None,
    solutionConfig: Option[zio.aws.personalize.model.SolutionConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.CreateSolutionRequest = {
    import CreateSolutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.CreateSolutionRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(performHPO.map(value => value: java.lang.Boolean))(
        _.performHPO
      )
      .optionallyWith(
        performAutoML.map(value =>
          PerformAutoML.unwrap(value): java.lang.Boolean
        )
      )(_.performAutoML)
      .optionallyWith(
        recipeArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.recipeArn)
      .datasetGroupArn(Arn.unwrap(datasetGroupArn): java.lang.String)
      .optionallyWith(
        eventType.map(value => EventType.unwrap(value): java.lang.String)
      )(_.eventType)
      .optionallyWith(solutionConfig.map(value => value.buildAwsValue()))(
        _.solutionConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.CreateSolutionRequest.ReadOnly =
    zio.aws.personalize.model.CreateSolutionRequest.wrap(buildAwsValue())
}
object CreateSolutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.CreateSolutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.CreateSolutionRequest =
      zio.aws.personalize.model.CreateSolutionRequest(
        name,
        performHPO.map(value => value),
        performAutoML.map(value => value),
        recipeArn.map(value => value),
        datasetGroupArn,
        eventType.map(value => value),
        solutionConfig.map(value => value.asEditable)
      )
    def name: Name
    def performHPO: Option[Boolean]
    def performAutoML: Option[PerformAutoML]
    def recipeArn: Option[Arn]
    def datasetGroupArn: Arn
    def eventType: Option[EventType]
    def solutionConfig
        : Option[zio.aws.personalize.model.SolutionConfig.ReadOnly]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getPerformHPO: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("performHPO", performHPO)
    def getPerformAutoML: ZIO[Any, AwsError, PerformAutoML] =
      AwsError.unwrapOptionField("performAutoML", performAutoML)
    def getRecipeArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("recipeArn", recipeArn)
    def getDatasetGroupArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(datasetGroupArn)
    def getEventType: ZIO[Any, AwsError, EventType] =
      AwsError.unwrapOptionField("eventType", eventType)
    def getSolutionConfig: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.SolutionConfig.ReadOnly
    ] = AwsError.unwrapOptionField("solutionConfig", solutionConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.CreateSolutionRequest
  ) extends zio.aws.personalize.model.CreateSolutionRequest.ReadOnly {
    override val name: Name =
      zio.aws.personalize.model.primitives.Name(impl.name())
    override val performHPO: Option[Boolean] =
      scala.Option(impl.performHPO()).map(value => value: Boolean)
    override val performAutoML: Option[PerformAutoML] = scala
      .Option(impl.performAutoML())
      .map(value => zio.aws.personalize.model.primitives.PerformAutoML(value))
    override val recipeArn: Option[Arn] = scala
      .Option(impl.recipeArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val datasetGroupArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.datasetGroupArn())
    override val eventType: Option[EventType] = scala
      .Option(impl.eventType())
      .map(value => zio.aws.personalize.model.primitives.EventType(value))
    override val solutionConfig
        : Option[zio.aws.personalize.model.SolutionConfig.ReadOnly] = scala
      .Option(impl.solutionConfig())
      .map(value => zio.aws.personalize.model.SolutionConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.CreateSolutionRequest
  ): zio.aws.personalize.model.CreateSolutionRequest.ReadOnly = new Wrapper(
    impl
  )
}
