package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class CreateSolutionResponse(solutionArn: Option[Arn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.CreateSolutionResponse = {
    import CreateSolutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.CreateSolutionResponse
      .builder()
      .optionallyWith(
        solutionArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.solutionArn)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.CreateSolutionResponse.ReadOnly =
    zio.aws.personalize.model.CreateSolutionResponse.wrap(buildAwsValue())
}
object CreateSolutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.CreateSolutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.CreateSolutionResponse =
      zio.aws.personalize.model
        .CreateSolutionResponse(solutionArn.map(value => value))
    def solutionArn: Option[Arn]
    def getSolutionArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("solutionArn", solutionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.CreateSolutionResponse
  ) extends zio.aws.personalize.model.CreateSolutionResponse.ReadOnly {
    override val solutionArn: Option[Arn] = scala
      .Option(impl.solutionArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.CreateSolutionResponse
  ): zio.aws.personalize.model.CreateSolutionResponse.ReadOnly = new Wrapper(
    impl
  )
}
