package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class CreateSolutionVersionRequest(
    solutionArn: Arn,
    trainingMode: Option[zio.aws.personalize.model.TrainingMode] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.CreateSolutionVersionRequest = {
    import CreateSolutionVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.CreateSolutionVersionRequest
      .builder()
      .solutionArn(Arn.unwrap(solutionArn): java.lang.String)
      .optionallyWith(trainingMode.map(value => value.unwrap))(_.trainingMode)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.CreateSolutionVersionRequest.ReadOnly =
    zio.aws.personalize.model.CreateSolutionVersionRequest.wrap(buildAwsValue())
}
object CreateSolutionVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.CreateSolutionVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.CreateSolutionVersionRequest =
      zio.aws.personalize.model.CreateSolutionVersionRequest(
        solutionArn,
        trainingMode.map(value => value)
      )
    def solutionArn: Arn
    def trainingMode: Option[zio.aws.personalize.model.TrainingMode]
    def getSolutionArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(solutionArn)
    def getTrainingMode
        : ZIO[Any, AwsError, zio.aws.personalize.model.TrainingMode] =
      AwsError.unwrapOptionField("trainingMode", trainingMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.CreateSolutionVersionRequest
  ) extends zio.aws.personalize.model.CreateSolutionVersionRequest.ReadOnly {
    override val solutionArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.solutionArn())
    override val trainingMode: Option[zio.aws.personalize.model.TrainingMode] =
      scala
        .Option(impl.trainingMode())
        .map(value => zio.aws.personalize.model.TrainingMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.CreateSolutionVersionRequest
  ): zio.aws.personalize.model.CreateSolutionVersionRequest.ReadOnly =
    new Wrapper(impl)
}
