package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class CreateSolutionVersionResponse(
    solutionVersionArn: Option[Arn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.CreateSolutionVersionResponse = {
    import CreateSolutionVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.CreateSolutionVersionResponse
      .builder()
      .optionallyWith(
        solutionVersionArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.solutionVersionArn)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.CreateSolutionVersionResponse.ReadOnly =
    zio.aws.personalize.model.CreateSolutionVersionResponse
      .wrap(buildAwsValue())
}
object CreateSolutionVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.CreateSolutionVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.CreateSolutionVersionResponse =
      zio.aws.personalize.model
        .CreateSolutionVersionResponse(solutionVersionArn.map(value => value))
    def solutionVersionArn: Option[Arn]
    def getSolutionVersionArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("solutionVersionArn", solutionVersionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.CreateSolutionVersionResponse
  ) extends zio.aws.personalize.model.CreateSolutionVersionResponse.ReadOnly {
    override val solutionVersionArn: Option[Arn] = scala
      .Option(impl.solutionVersionArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.CreateSolutionVersionResponse
  ): zio.aws.personalize.model.CreateSolutionVersionResponse.ReadOnly =
    new Wrapper(impl)
}
