package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{
  Status,
  Date,
  FailureReason,
  Arn,
  Name
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DatasetExportJobSummary(
    datasetExportJobArn: Option[Arn] = None,
    jobName: Option[Name] = None,
    status: Option[Status] = None,
    creationDateTime: Option[Date] = None,
    lastUpdatedDateTime: Option[Date] = None,
    failureReason: Option[FailureReason] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DatasetExportJobSummary = {
    import DatasetExportJobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DatasetExportJobSummary
      .builder()
      .optionallyWith(
        datasetExportJobArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetExportJobArn)
      .optionallyWith(
        jobName.map(value => Name.unwrap(value): java.lang.String)
      )(_.jobName)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.DatasetExportJobSummary.ReadOnly =
    zio.aws.personalize.model.DatasetExportJobSummary.wrap(buildAwsValue())
}
object DatasetExportJobSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DatasetExportJobSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DatasetExportJobSummary =
      zio.aws.personalize.model.DatasetExportJobSummary(
        datasetExportJobArn.map(value => value),
        jobName.map(value => value),
        status.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value),
        failureReason.map(value => value)
      )
    def datasetExportJobArn: Option[Arn]
    def jobName: Option[Name]
    def status: Option[Status]
    def creationDateTime: Option[Date]
    def lastUpdatedDateTime: Option[Date]
    def failureReason: Option[FailureReason]
    def getDatasetExportJobArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetExportJobArn", datasetExportJobArn)
    def getJobName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("jobName", jobName)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DatasetExportJobSummary
  ) extends zio.aws.personalize.model.DatasetExportJobSummary.ReadOnly {
    override val datasetExportJobArn: Option[Arn] = scala
      .Option(impl.datasetExportJobArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val jobName: Option[Name] = scala
      .Option(impl.jobName())
      .map(value => zio.aws.personalize.model.primitives.Name(value))
    override val status: Option[Status] = scala
      .Option(impl.status())
      .map(value => zio.aws.personalize.model.primitives.Status(value))
    override val creationDateTime: Option[Date] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val lastUpdatedDateTime: Option[Date] = scala
      .Option(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val failureReason: Option[FailureReason] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.personalize.model.primitives.FailureReason(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DatasetExportJobSummary
  ): zio.aws.personalize.model.DatasetExportJobSummary.ReadOnly = new Wrapper(
    impl
  )
}
