package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{
  Status,
  RoleArn,
  Date,
  FailureReason,
  Arn,
  KmsKeyArn,
  Name
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DatasetGroup(
    name: Option[Name] = None,
    datasetGroupArn: Option[Arn] = None,
    status: Option[Status] = None,
    roleArn: Option[RoleArn] = None,
    kmsKeyArn: Option[KmsKeyArn] = None,
    creationDateTime: Option[Date] = None,
    lastUpdatedDateTime: Option[Date] = None,
    failureReason: Option[FailureReason] = None,
    domain: Option[zio.aws.personalize.model.Domain] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DatasetGroup = {
    import DatasetGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DatasetGroup
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        datasetGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetGroupArn)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        kmsKeyArn.map(value => KmsKeyArn.unwrap(value): java.lang.String)
      )(_.kmsKeyArn)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(domain.map(value => value.unwrap))(_.domain)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.DatasetGroup.ReadOnly =
    zio.aws.personalize.model.DatasetGroup.wrap(buildAwsValue())
}
object DatasetGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DatasetGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DatasetGroup =
      zio.aws.personalize.model.DatasetGroup(
        name.map(value => value),
        datasetGroupArn.map(value => value),
        status.map(value => value),
        roleArn.map(value => value),
        kmsKeyArn.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value),
        failureReason.map(value => value),
        domain.map(value => value)
      )
    def name: Option[Name]
    def datasetGroupArn: Option[Arn]
    def status: Option[Status]
    def roleArn: Option[RoleArn]
    def kmsKeyArn: Option[KmsKeyArn]
    def creationDateTime: Option[Date]
    def lastUpdatedDateTime: Option[Date]
    def failureReason: Option[FailureReason]
    def domain: Option[zio.aws.personalize.model.Domain]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getDatasetGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetGroupArn", datasetGroupArn)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getKmsKeyArn: ZIO[Any, AwsError, KmsKeyArn] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getDomain: ZIO[Any, AwsError, zio.aws.personalize.model.Domain] =
      AwsError.unwrapOptionField("domain", domain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DatasetGroup
  ) extends zio.aws.personalize.model.DatasetGroup.ReadOnly {
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.personalize.model.primitives.Name(value))
    override val datasetGroupArn: Option[Arn] = scala
      .Option(impl.datasetGroupArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val status: Option[Status] = scala
      .Option(impl.status())
      .map(value => zio.aws.personalize.model.primitives.Status(value))
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.personalize.model.primitives.RoleArn(value))
    override val kmsKeyArn: Option[KmsKeyArn] = scala
      .Option(impl.kmsKeyArn())
      .map(value => zio.aws.personalize.model.primitives.KmsKeyArn(value))
    override val creationDateTime: Option[Date] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val lastUpdatedDateTime: Option[Date] = scala
      .Option(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val failureReason: Option[FailureReason] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.personalize.model.primitives.FailureReason(value))
    override val domain: Option[zio.aws.personalize.model.Domain] = scala
      .Option(impl.domain())
      .map(value => zio.aws.personalize.model.Domain.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DatasetGroup
  ): zio.aws.personalize.model.DatasetGroup.ReadOnly = new Wrapper(impl)
}
