package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DefaultHyperParameterRanges(
    integerHyperParameterRanges: Option[
      Iterable[zio.aws.personalize.model.DefaultIntegerHyperParameterRange]
    ] = None,
    continuousHyperParameterRanges: Option[
      Iterable[zio.aws.personalize.model.DefaultContinuousHyperParameterRange]
    ] = None,
    categoricalHyperParameterRanges: Option[
      Iterable[zio.aws.personalize.model.DefaultCategoricalHyperParameterRange]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DefaultHyperParameterRanges = {
    import DefaultHyperParameterRanges.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DefaultHyperParameterRanges
      .builder()
      .optionallyWith(
        integerHyperParameterRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.integerHyperParameterRanges)
      .optionallyWith(
        continuousHyperParameterRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.continuousHyperParameterRanges)
      .optionallyWith(
        categoricalHyperParameterRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.categoricalHyperParameterRanges)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.DefaultHyperParameterRanges.ReadOnly =
    zio.aws.personalize.model.DefaultHyperParameterRanges.wrap(buildAwsValue())
}
object DefaultHyperParameterRanges {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DefaultHyperParameterRanges
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DefaultHyperParameterRanges =
      zio.aws.personalize.model.DefaultHyperParameterRanges(
        integerHyperParameterRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        continuousHyperParameterRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        categoricalHyperParameterRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def integerHyperParameterRanges: Option[
      List[zio.aws.personalize.model.DefaultIntegerHyperParameterRange.ReadOnly]
    ]
    def continuousHyperParameterRanges: Option[List[
      zio.aws.personalize.model.DefaultContinuousHyperParameterRange.ReadOnly
    ]]
    def categoricalHyperParameterRanges: Option[List[
      zio.aws.personalize.model.DefaultCategoricalHyperParameterRange.ReadOnly
    ]]
    def getIntegerHyperParameterRanges: ZIO[Any, AwsError, List[
      zio.aws.personalize.model.DefaultIntegerHyperParameterRange.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "integerHyperParameterRanges",
      integerHyperParameterRanges
    )
    def getContinuousHyperParameterRanges: ZIO[Any, AwsError, List[
      zio.aws.personalize.model.DefaultContinuousHyperParameterRange.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "continuousHyperParameterRanges",
      continuousHyperParameterRanges
    )
    def getCategoricalHyperParameterRanges: ZIO[Any, AwsError, List[
      zio.aws.personalize.model.DefaultCategoricalHyperParameterRange.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "categoricalHyperParameterRanges",
      categoricalHyperParameterRanges
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DefaultHyperParameterRanges
  ) extends zio.aws.personalize.model.DefaultHyperParameterRanges.ReadOnly {
    override val integerHyperParameterRanges: Option[
      List[zio.aws.personalize.model.DefaultIntegerHyperParameterRange.ReadOnly]
    ] = scala
      .Option(impl.integerHyperParameterRanges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.personalize.model.DefaultIntegerHyperParameterRange.wrap(item)
        }.toList
      )
    override val continuousHyperParameterRanges: Option[List[
      zio.aws.personalize.model.DefaultContinuousHyperParameterRange.ReadOnly
    ]] = scala
      .Option(impl.continuousHyperParameterRanges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.personalize.model.DefaultContinuousHyperParameterRange
            .wrap(item)
        }.toList
      )
    override val categoricalHyperParameterRanges: Option[List[
      zio.aws.personalize.model.DefaultCategoricalHyperParameterRange.ReadOnly
    ]] = scala
      .Option(impl.categoricalHyperParameterRanges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.personalize.model.DefaultCategoricalHyperParameterRange
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DefaultHyperParameterRanges
  ): zio.aws.personalize.model.DefaultHyperParameterRanges.ReadOnly =
    new Wrapper(impl)
}
