package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class DeleteCampaignRequest(campaignArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DeleteCampaignRequest = {
    import DeleteCampaignRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DeleteCampaignRequest
      .builder()
      .campaignArn(Arn.unwrap(campaignArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.DeleteCampaignRequest.ReadOnly =
    zio.aws.personalize.model.DeleteCampaignRequest.wrap(buildAwsValue())
}
object DeleteCampaignRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DeleteCampaignRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DeleteCampaignRequest =
      zio.aws.personalize.model.DeleteCampaignRequest(campaignArn)
    def campaignArn: Arn
    def getCampaignArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(campaignArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DeleteCampaignRequest
  ) extends zio.aws.personalize.model.DeleteCampaignRequest.ReadOnly {
    override val campaignArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.campaignArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DeleteCampaignRequest
  ): zio.aws.personalize.model.DeleteCampaignRequest.ReadOnly = new Wrapper(
    impl
  )
}
