package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class DeleteEventTrackerRequest(eventTrackerArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DeleteEventTrackerRequest = {
    import DeleteEventTrackerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DeleteEventTrackerRequest
      .builder()
      .eventTrackerArn(Arn.unwrap(eventTrackerArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.DeleteEventTrackerRequest.ReadOnly =
    zio.aws.personalize.model.DeleteEventTrackerRequest.wrap(buildAwsValue())
}
object DeleteEventTrackerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DeleteEventTrackerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DeleteEventTrackerRequest =
      zio.aws.personalize.model.DeleteEventTrackerRequest(eventTrackerArn)
    def eventTrackerArn: Arn
    def getEventTrackerArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(eventTrackerArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DeleteEventTrackerRequest
  ) extends zio.aws.personalize.model.DeleteEventTrackerRequest.ReadOnly {
    override val eventTrackerArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.eventTrackerArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DeleteEventTrackerRequest
  ): zio.aws.personalize.model.DeleteEventTrackerRequest.ReadOnly = new Wrapper(
    impl
  )
}
