package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class DescribeBatchInferenceJobRequest(batchInferenceJobArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DescribeBatchInferenceJobRequest = {
    import DescribeBatchInferenceJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DescribeBatchInferenceJobRequest
      .builder()
      .batchInferenceJobArn(Arn.unwrap(batchInferenceJobArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.DescribeBatchInferenceJobRequest.ReadOnly =
    zio.aws.personalize.model.DescribeBatchInferenceJobRequest
      .wrap(buildAwsValue())
}
object DescribeBatchInferenceJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DescribeBatchInferenceJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DescribeBatchInferenceJobRequest =
      zio.aws.personalize.model
        .DescribeBatchInferenceJobRequest(batchInferenceJobArn)
    def batchInferenceJobArn: Arn
    def getBatchInferenceJobArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(batchInferenceJobArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DescribeBatchInferenceJobRequest
  ) extends zio.aws.personalize.model.DescribeBatchInferenceJobRequest.ReadOnly {
    override val batchInferenceJobArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.batchInferenceJobArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DescribeBatchInferenceJobRequest
  ): zio.aws.personalize.model.DescribeBatchInferenceJobRequest.ReadOnly =
    new Wrapper(impl)
}
