package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeBatchInferenceJobResponse(
    batchInferenceJob: Option[zio.aws.personalize.model.BatchInferenceJob] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DescribeBatchInferenceJobResponse = {
    import DescribeBatchInferenceJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DescribeBatchInferenceJobResponse
      .builder()
      .optionallyWith(batchInferenceJob.map(value => value.buildAwsValue()))(
        _.batchInferenceJob
      )
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.DescribeBatchInferenceJobResponse.ReadOnly =
    zio.aws.personalize.model.DescribeBatchInferenceJobResponse
      .wrap(buildAwsValue())
}
object DescribeBatchInferenceJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DescribeBatchInferenceJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.personalize.model.DescribeBatchInferenceJobResponse =
      zio.aws.personalize.model.DescribeBatchInferenceJobResponse(
        batchInferenceJob.map(value => value.asEditable)
      )
    def batchInferenceJob
        : Option[zio.aws.personalize.model.BatchInferenceJob.ReadOnly]
    def getBatchInferenceJob: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.BatchInferenceJob.ReadOnly
    ] = AwsError.unwrapOptionField("batchInferenceJob", batchInferenceJob)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DescribeBatchInferenceJobResponse
  ) extends zio.aws.personalize.model.DescribeBatchInferenceJobResponse.ReadOnly {
    override val batchInferenceJob
        : Option[zio.aws.personalize.model.BatchInferenceJob.ReadOnly] = scala
      .Option(impl.batchInferenceJob())
      .map(value => zio.aws.personalize.model.BatchInferenceJob.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DescribeBatchInferenceJobResponse
  ): zio.aws.personalize.model.DescribeBatchInferenceJobResponse.ReadOnly =
    new Wrapper(impl)
}
