package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeCampaignResponse(
    campaign: Option[zio.aws.personalize.model.Campaign] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DescribeCampaignResponse = {
    import DescribeCampaignResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DescribeCampaignResponse
      .builder()
      .optionallyWith(campaign.map(value => value.buildAwsValue()))(_.campaign)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.DescribeCampaignResponse.ReadOnly =
    zio.aws.personalize.model.DescribeCampaignResponse.wrap(buildAwsValue())
}
object DescribeCampaignResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DescribeCampaignResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DescribeCampaignResponse =
      zio.aws.personalize.model
        .DescribeCampaignResponse(campaign.map(value => value.asEditable))
    def campaign: Option[zio.aws.personalize.model.Campaign.ReadOnly]
    def getCampaign
        : ZIO[Any, AwsError, zio.aws.personalize.model.Campaign.ReadOnly] =
      AwsError.unwrapOptionField("campaign", campaign)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DescribeCampaignResponse
  ) extends zio.aws.personalize.model.DescribeCampaignResponse.ReadOnly {
    override val campaign: Option[zio.aws.personalize.model.Campaign.ReadOnly] =
      scala
        .Option(impl.campaign())
        .map(value => zio.aws.personalize.model.Campaign.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DescribeCampaignResponse
  ): zio.aws.personalize.model.DescribeCampaignResponse.ReadOnly = new Wrapper(
    impl
  )
}
