package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeDatasetGroupResponse(
    datasetGroup: Option[zio.aws.personalize.model.DatasetGroup] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DescribeDatasetGroupResponse = {
    import DescribeDatasetGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DescribeDatasetGroupResponse
      .builder()
      .optionallyWith(datasetGroup.map(value => value.buildAwsValue()))(
        _.datasetGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.DescribeDatasetGroupResponse.ReadOnly =
    zio.aws.personalize.model.DescribeDatasetGroupResponse.wrap(buildAwsValue())
}
object DescribeDatasetGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DescribeDatasetGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DescribeDatasetGroupResponse =
      zio.aws.personalize.model.DescribeDatasetGroupResponse(
        datasetGroup.map(value => value.asEditable)
      )
    def datasetGroup: Option[zio.aws.personalize.model.DatasetGroup.ReadOnly]
    def getDatasetGroup
        : ZIO[Any, AwsError, zio.aws.personalize.model.DatasetGroup.ReadOnly] =
      AwsError.unwrapOptionField("datasetGroup", datasetGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DescribeDatasetGroupResponse
  ) extends zio.aws.personalize.model.DescribeDatasetGroupResponse.ReadOnly {
    override val datasetGroup
        : Option[zio.aws.personalize.model.DatasetGroup.ReadOnly] = scala
      .Option(impl.datasetGroup())
      .map(value => zio.aws.personalize.model.DatasetGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DescribeDatasetGroupResponse
  ): zio.aws.personalize.model.DescribeDatasetGroupResponse.ReadOnly =
    new Wrapper(impl)
}
