package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class DescribeEventTrackerRequest(eventTrackerArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DescribeEventTrackerRequest = {
    import DescribeEventTrackerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DescribeEventTrackerRequest
      .builder()
      .eventTrackerArn(Arn.unwrap(eventTrackerArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.DescribeEventTrackerRequest.ReadOnly =
    zio.aws.personalize.model.DescribeEventTrackerRequest.wrap(buildAwsValue())
}
object DescribeEventTrackerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DescribeEventTrackerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DescribeEventTrackerRequest =
      zio.aws.personalize.model.DescribeEventTrackerRequest(eventTrackerArn)
    def eventTrackerArn: Arn
    def getEventTrackerArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(eventTrackerArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DescribeEventTrackerRequest
  ) extends zio.aws.personalize.model.DescribeEventTrackerRequest.ReadOnly {
    override val eventTrackerArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.eventTrackerArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DescribeEventTrackerRequest
  ): zio.aws.personalize.model.DescribeEventTrackerRequest.ReadOnly =
    new Wrapper(impl)
}
