package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeSchemaResponse(
    schema: Option[zio.aws.personalize.model.DatasetSchema] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DescribeSchemaResponse = {
    import DescribeSchemaResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DescribeSchemaResponse
      .builder()
      .optionallyWith(schema.map(value => value.buildAwsValue()))(_.schema)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.DescribeSchemaResponse.ReadOnly =
    zio.aws.personalize.model.DescribeSchemaResponse.wrap(buildAwsValue())
}
object DescribeSchemaResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DescribeSchemaResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DescribeSchemaResponse =
      zio.aws.personalize.model
        .DescribeSchemaResponse(schema.map(value => value.asEditable))
    def schema: Option[zio.aws.personalize.model.DatasetSchema.ReadOnly]
    def getSchema
        : ZIO[Any, AwsError, zio.aws.personalize.model.DatasetSchema.ReadOnly] =
      AwsError.unwrapOptionField("schema", schema)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DescribeSchemaResponse
  ) extends zio.aws.personalize.model.DescribeSchemaResponse.ReadOnly {
    override val schema
        : Option[zio.aws.personalize.model.DatasetSchema.ReadOnly] = scala
      .Option(impl.schema())
      .map(value => zio.aws.personalize.model.DatasetSchema.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DescribeSchemaResponse
  ): zio.aws.personalize.model.DescribeSchemaResponse.ReadOnly = new Wrapper(
    impl
  )
}
