package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{
  Status,
  Date,
  FailureReason,
  Arn,
  Name
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class FilterSummary(
    name: Option[Name] = None,
    filterArn: Option[Arn] = None,
    creationDateTime: Option[Date] = None,
    lastUpdatedDateTime: Option[Date] = None,
    datasetGroupArn: Option[Arn] = None,
    failureReason: Option[FailureReason] = None,
    status: Option[Status] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.FilterSummary = {
    import FilterSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.FilterSummary
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        filterArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.filterArn)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(
        datasetGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetGroupArn)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.FilterSummary.ReadOnly =
    zio.aws.personalize.model.FilterSummary.wrap(buildAwsValue())
}
object FilterSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.FilterSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.FilterSummary =
      zio.aws.personalize.model.FilterSummary(
        name.map(value => value),
        filterArn.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value),
        datasetGroupArn.map(value => value),
        failureReason.map(value => value),
        status.map(value => value)
      )
    def name: Option[Name]
    def filterArn: Option[Arn]
    def creationDateTime: Option[Date]
    def lastUpdatedDateTime: Option[Date]
    def datasetGroupArn: Option[Arn]
    def failureReason: Option[FailureReason]
    def status: Option[Status]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getFilterArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("filterArn", filterArn)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getDatasetGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetGroupArn", datasetGroupArn)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.FilterSummary
  ) extends zio.aws.personalize.model.FilterSummary.ReadOnly {
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.personalize.model.primitives.Name(value))
    override val filterArn: Option[Arn] = scala
      .Option(impl.filterArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val creationDateTime: Option[Date] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val lastUpdatedDateTime: Option[Date] = scala
      .Option(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val datasetGroupArn: Option[Arn] = scala
      .Option(impl.datasetGroupArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val failureReason: Option[FailureReason] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.personalize.model.primitives.FailureReason(value))
    override val status: Option[Status] = scala
      .Option(impl.status())
      .map(value => zio.aws.personalize.model.primitives.Status(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.FilterSummary
  ): zio.aws.personalize.model.FilterSummary.ReadOnly = new Wrapper(impl)
}
