package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class HPOConfig(
    hpoObjective: Option[zio.aws.personalize.model.HPOObjective] = None,
    hpoResourceConfig: Option[zio.aws.personalize.model.HPOResourceConfig] =
      None,
    algorithmHyperParameterRanges: Option[
      zio.aws.personalize.model.HyperParameterRanges
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.HPOConfig = {
    import HPOConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.HPOConfig
      .builder()
      .optionallyWith(hpoObjective.map(value => value.buildAwsValue()))(
        _.hpoObjective
      )
      .optionallyWith(hpoResourceConfig.map(value => value.buildAwsValue()))(
        _.hpoResourceConfig
      )
      .optionallyWith(
        algorithmHyperParameterRanges.map(value => value.buildAwsValue())
      )(_.algorithmHyperParameterRanges)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.HPOConfig.ReadOnly =
    zio.aws.personalize.model.HPOConfig.wrap(buildAwsValue())
}
object HPOConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.HPOConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.HPOConfig =
      zio.aws.personalize.model.HPOConfig(
        hpoObjective.map(value => value.asEditable),
        hpoResourceConfig.map(value => value.asEditable),
        algorithmHyperParameterRanges.map(value => value.asEditable)
      )
    def hpoObjective: Option[zio.aws.personalize.model.HPOObjective.ReadOnly]
    def hpoResourceConfig
        : Option[zio.aws.personalize.model.HPOResourceConfig.ReadOnly]
    def algorithmHyperParameterRanges
        : Option[zio.aws.personalize.model.HyperParameterRanges.ReadOnly]
    def getHpoObjective
        : ZIO[Any, AwsError, zio.aws.personalize.model.HPOObjective.ReadOnly] =
      AwsError.unwrapOptionField("hpoObjective", hpoObjective)
    def getHpoResourceConfig: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.HPOResourceConfig.ReadOnly
    ] = AwsError.unwrapOptionField("hpoResourceConfig", hpoResourceConfig)
    def getAlgorithmHyperParameterRanges: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.HyperParameterRanges.ReadOnly
    ] = AwsError.unwrapOptionField(
      "algorithmHyperParameterRanges",
      algorithmHyperParameterRanges
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.HPOConfig
  ) extends zio.aws.personalize.model.HPOConfig.ReadOnly {
    override val hpoObjective
        : Option[zio.aws.personalize.model.HPOObjective.ReadOnly] = scala
      .Option(impl.hpoObjective())
      .map(value => zio.aws.personalize.model.HPOObjective.wrap(value))
    override val hpoResourceConfig
        : Option[zio.aws.personalize.model.HPOResourceConfig.ReadOnly] = scala
      .Option(impl.hpoResourceConfig())
      .map(value => zio.aws.personalize.model.HPOResourceConfig.wrap(value))
    override val algorithmHyperParameterRanges
        : Option[zio.aws.personalize.model.HyperParameterRanges.ReadOnly] =
      scala
        .Option(impl.algorithmHyperParameterRanges())
        .map(value =>
          zio.aws.personalize.model.HyperParameterRanges.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.HPOConfig
  ): zio.aws.personalize.model.HPOConfig.ReadOnly = new Wrapper(impl)
}
