package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{
  MetricRegex,
  MetricName,
  HPOObjectiveType
}
import scala.jdk.CollectionConverters.*
final case class HPOObjective(
    `type`: Option[HPOObjectiveType] = None,
    metricName: Option[MetricName] = None,
    metricRegex: Option[MetricRegex] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.HPOObjective = {
    import HPOObjective.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.HPOObjective
      .builder()
      .optionallyWith(
        `type`.map(value => HPOObjectiveType.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(
        metricName.map(value => MetricName.unwrap(value): java.lang.String)
      )(_.metricName)
      .optionallyWith(
        metricRegex.map(value => MetricRegex.unwrap(value): java.lang.String)
      )(_.metricRegex)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.HPOObjective.ReadOnly =
    zio.aws.personalize.model.HPOObjective.wrap(buildAwsValue())
}
object HPOObjective {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.HPOObjective
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.HPOObjective =
      zio.aws.personalize.model.HPOObjective(
        `type`.map(value => value),
        metricName.map(value => value),
        metricRegex.map(value => value)
      )
    def `type`: Option[HPOObjectiveType]
    def metricName: Option[MetricName]
    def metricRegex: Option[MetricRegex]
    def getType: ZIO[Any, AwsError, HPOObjectiveType] =
      AwsError.unwrapOptionField("type", `type`)
    def getMetricName: ZIO[Any, AwsError, MetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getMetricRegex: ZIO[Any, AwsError, MetricRegex] =
      AwsError.unwrapOptionField("metricRegex", metricRegex)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.HPOObjective
  ) extends zio.aws.personalize.model.HPOObjective.ReadOnly {
    override val `type`: Option[HPOObjectiveType] = scala
      .Option(impl.`type`())
      .map(value =>
        zio.aws.personalize.model.primitives.HPOObjectiveType(value)
      )
    override val metricName: Option[MetricName] = scala
      .Option(impl.metricName())
      .map(value => zio.aws.personalize.model.primitives.MetricName(value))
    override val metricRegex: Option[MetricRegex] = scala
      .Option(impl.metricRegex())
      .map(value => zio.aws.personalize.model.primitives.MetricRegex(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.HPOObjective
  ): zio.aws.personalize.model.HPOObjective.ReadOnly = new Wrapper(impl)
}
