package zio.aws.personalize.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{MaxResults, NextToken, Arn}
import scala.jdk.CollectionConverters.*
final case class ListBatchSegmentJobsRequest(
    solutionVersionArn: Option[Arn] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.ListBatchSegmentJobsRequest = {
    import ListBatchSegmentJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.ListBatchSegmentJobsRequest
      .builder()
      .optionallyWith(
        solutionVersionArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.solutionVersionArn)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.ListBatchSegmentJobsRequest.ReadOnly =
    zio.aws.personalize.model.ListBatchSegmentJobsRequest.wrap(buildAwsValue())
}
object ListBatchSegmentJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.ListBatchSegmentJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.ListBatchSegmentJobsRequest =
      zio.aws.personalize.model.ListBatchSegmentJobsRequest(
        solutionVersionArn.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def solutionVersionArn: Option[Arn]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getSolutionVersionArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("solutionVersionArn", solutionVersionArn)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.ListBatchSegmentJobsRequest
  ) extends zio.aws.personalize.model.ListBatchSegmentJobsRequest.ReadOnly {
    override val solutionVersionArn: Option[Arn] = scala
      .Option(impl.solutionVersionArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.personalize.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.personalize.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.ListBatchSegmentJobsRequest
  ): zio.aws.personalize.model.ListBatchSegmentJobsRequest.ReadOnly =
    new Wrapper(impl)
}
