package zio.aws.personalize.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{MaxResults, NextToken, Arn}
import scala.jdk.CollectionConverters.*
final case class ListCampaignsRequest(
    solutionArn: Option[Arn] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.ListCampaignsRequest = {
    import ListCampaignsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.ListCampaignsRequest
      .builder()
      .optionallyWith(
        solutionArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.solutionArn)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.ListCampaignsRequest.ReadOnly =
    zio.aws.personalize.model.ListCampaignsRequest.wrap(buildAwsValue())
}
object ListCampaignsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.ListCampaignsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.ListCampaignsRequest =
      zio.aws.personalize.model.ListCampaignsRequest(
        solutionArn.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def solutionArn: Option[Arn]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getSolutionArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("solutionArn", solutionArn)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.ListCampaignsRequest
  ) extends zio.aws.personalize.model.ListCampaignsRequest.ReadOnly {
    override val solutionArn: Option[Arn] = scala
      .Option(impl.solutionArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.personalize.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.personalize.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.ListCampaignsRequest
  ): zio.aws.personalize.model.ListCampaignsRequest.ReadOnly = new Wrapper(impl)
}
