package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListDatasetExportJobsResponse(
    datasetExportJobs: Option[
      Iterable[zio.aws.personalize.model.DatasetExportJobSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.ListDatasetExportJobsResponse = {
    import ListDatasetExportJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.ListDatasetExportJobsResponse
      .builder()
      .optionallyWith(
        datasetExportJobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.datasetExportJobs)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.ListDatasetExportJobsResponse.ReadOnly =
    zio.aws.personalize.model.ListDatasetExportJobsResponse
      .wrap(buildAwsValue())
}
object ListDatasetExportJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.ListDatasetExportJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.ListDatasetExportJobsResponse =
      zio.aws.personalize.model.ListDatasetExportJobsResponse(
        datasetExportJobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def datasetExportJobs: Option[
      List[zio.aws.personalize.model.DatasetExportJobSummary.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getDatasetExportJobs: ZIO[Any, AwsError, List[
      zio.aws.personalize.model.DatasetExportJobSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("datasetExportJobs", datasetExportJobs)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.ListDatasetExportJobsResponse
  ) extends zio.aws.personalize.model.ListDatasetExportJobsResponse.ReadOnly {
    override val datasetExportJobs: Option[
      List[zio.aws.personalize.model.DatasetExportJobSummary.ReadOnly]
    ] = scala
      .Option(impl.datasetExportJobs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.personalize.model.DatasetExportJobSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.personalize.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.ListDatasetExportJobsResponse
  ): zio.aws.personalize.model.ListDatasetExportJobsResponse.ReadOnly =
    new Wrapper(impl)
}
