package zio.aws.personalize.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{MaxResults, NextToken, Arn}
import scala.jdk.CollectionConverters.*
final case class ListEventTrackersRequest(
    datasetGroupArn: Option[Arn] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.ListEventTrackersRequest = {
    import ListEventTrackersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.ListEventTrackersRequest
      .builder()
      .optionallyWith(
        datasetGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetGroupArn)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.ListEventTrackersRequest.ReadOnly =
    zio.aws.personalize.model.ListEventTrackersRequest.wrap(buildAwsValue())
}
object ListEventTrackersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.ListEventTrackersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.ListEventTrackersRequest =
      zio.aws.personalize.model.ListEventTrackersRequest(
        datasetGroupArn.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def datasetGroupArn: Option[Arn]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getDatasetGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetGroupArn", datasetGroupArn)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.ListEventTrackersRequest
  ) extends zio.aws.personalize.model.ListEventTrackersRequest.ReadOnly {
    override val datasetGroupArn: Option[Arn] = scala
      .Option(impl.datasetGroupArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.personalize.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.personalize.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.ListEventTrackersRequest
  ): zio.aws.personalize.model.ListEventTrackersRequest.ReadOnly = new Wrapper(
    impl
  )
}
