package zio.aws.personalize.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{MaxResults, NextToken}
import scala.jdk.CollectionConverters.*
final case class ListRecipesRequest(
    recipeProvider: Option[zio.aws.personalize.model.RecipeProvider] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None,
    domain: Option[zio.aws.personalize.model.Domain] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.ListRecipesRequest = {
    import ListRecipesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.ListRecipesRequest
      .builder()
      .optionallyWith(recipeProvider.map(value => value.unwrap))(
        _.recipeProvider
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(domain.map(value => value.unwrap))(_.domain)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.ListRecipesRequest.ReadOnly =
    zio.aws.personalize.model.ListRecipesRequest.wrap(buildAwsValue())
}
object ListRecipesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.ListRecipesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.ListRecipesRequest =
      zio.aws.personalize.model.ListRecipesRequest(
        recipeProvider.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        domain.map(value => value)
      )
    def recipeProvider: Option[zio.aws.personalize.model.RecipeProvider]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def domain: Option[zio.aws.personalize.model.Domain]
    def getRecipeProvider
        : ZIO[Any, AwsError, zio.aws.personalize.model.RecipeProvider] =
      AwsError.unwrapOptionField("recipeProvider", recipeProvider)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getDomain: ZIO[Any, AwsError, zio.aws.personalize.model.Domain] =
      AwsError.unwrapOptionField("domain", domain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.ListRecipesRequest
  ) extends zio.aws.personalize.model.ListRecipesRequest.ReadOnly {
    override val recipeProvider
        : Option[zio.aws.personalize.model.RecipeProvider] = scala
      .Option(impl.recipeProvider())
      .map(value => zio.aws.personalize.model.RecipeProvider.wrap(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.personalize.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.personalize.model.primitives.MaxResults(value))
    override val domain: Option[zio.aws.personalize.model.Domain] = scala
      .Option(impl.domain())
      .map(value => zio.aws.personalize.model.Domain.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.ListRecipesRequest
  ): zio.aws.personalize.model.ListRecipesRequest.ReadOnly = new Wrapper(impl)
}
