package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListRecommendersResponse(
    recommenders: Option[
      Iterable[zio.aws.personalize.model.RecommenderSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.ListRecommendersResponse = {
    import ListRecommendersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.ListRecommendersResponse
      .builder()
      .optionallyWith(
        recommenders.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recommenders)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.ListRecommendersResponse.ReadOnly =
    zio.aws.personalize.model.ListRecommendersResponse.wrap(buildAwsValue())
}
object ListRecommendersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.ListRecommendersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.ListRecommendersResponse =
      zio.aws.personalize.model.ListRecommendersResponse(
        recommenders.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def recommenders
        : Option[List[zio.aws.personalize.model.RecommenderSummary.ReadOnly]]
    def nextToken: Option[NextToken]
    def getRecommenders: ZIO[Any, AwsError, List[
      zio.aws.personalize.model.RecommenderSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("recommenders", recommenders)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.ListRecommendersResponse
  ) extends zio.aws.personalize.model.ListRecommendersResponse.ReadOnly {
    override val recommenders
        : Option[List[zio.aws.personalize.model.RecommenderSummary.ReadOnly]] =
      scala
        .Option(impl.recommenders())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.personalize.model.RecommenderSummary.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.personalize.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.ListRecommendersResponse
  ): zio.aws.personalize.model.ListRecommendersResponse.ReadOnly = new Wrapper(
    impl
  )
}
